/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.json.JSONObject;

public class JSONObjectContains
extends TypeSafeMatcher<JSONObject> {
    private final Iterable<String> keys;

    public JSONObjectContains(String ... keys) {
        this.keys = Lists.newArrayList((Object[])keys);
    }

    protected boolean matchesSafely(final JSONObject jsonObject) {
        return Iterables.all(this.keys, (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return jsonObject.has(key);
            }
        });
    }

    public void describeTo(Description description) {
        description.appendText("Json object didn't contain the following keys " + this.keys);
    }
}

