/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.AbstractBuildNumberRule;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Supplier;
import org.junit.rules.TestRule;

public class BeforeBuildRule
extends AbstractBuildNumberRule<BeforeBuild>
implements TestRule {
    public BeforeBuildRule(Supplier<Backdoor> backdoor) {
        super(backdoor, BeforeBuild.class, (annotation, dbBuildNumber) -> annotation.buildNumber() <= dbBuildNumber, BeforeBuild::buildNumber);
    }

    @Override
    String describeUnsatisfiedRule(String testName, int annotationBuildNumber, int dbBuildNumber) {
        return testName + " was ignored as it only exists before " + annotationBuildNumber + " (current: " + dbBuildNumber + ")";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BeforeBuild {
        public int buildNumber();
    }
}

