/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.rules.ExternalResource;

class CleanDirectoryRule
extends ExternalResource {
    private Supplier<File> directory;

    CleanDirectoryRule(File directory) {
        this.directory = () -> directory;
    }

    CleanDirectoryRule(java.util.function.Supplier<File> directory) {
        this.directory = Suppliers.memoize(directory::get);
    }

    protected void before() throws Throwable {
        super.before();
        this.cleanDirectory();
    }

    private void cleanDirectory() {
        File directory = (File)this.directory.get();
        try {
            if (directory.exists() && directory.isDirectory()) {
                FileUtils.cleanDirectory((File)directory);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void after() {
        super.after();
        this.cleanDirectory();
    }
}

