/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.backdoor.InstanceFeaturesControl;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableBigPipeRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(DisableBigPipeRule.class);
    private final Supplier<Backdoor> backdoor;

    public DisableBigPipeRule(Supplier<Backdoor> backdoorModule) {
        this.backdoor = backdoorModule;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (!DisableBigPipeRule.this.isBigpipeEnabled()) {
                        base.evaluate();
                    } else {
                        DisableBigPipeRule.this.setBigpipeEnabled(false);
                        base.evaluate();
                        DisableBigPipeRule.this.setBigpipeEnabled(true);
                    }
                }
                catch (Exception e) {
                    log.error("Could not disable BigPipe", (Throwable)e);
                    base.evaluate();
                }
            }
        };
    }

    private boolean isBigpipeEnabled() {
        InstanceFeaturesControl instanceFeaturesControl = this.getInstanceFeaturesControl();
        return !instanceFeaturesControl.isEnabled("com.atlassian.jira.config.BIG_PIPE_KILLSWITCH");
    }

    private void setBigpipeEnabled(boolean flag) {
        InstanceFeaturesControl instanceFeaturesControl = this.getInstanceFeaturesControl();
        Optional.of("com.atlassian.jira.config.BIG_PIPE_KILLSWITCH").ifPresent(flag ? instanceFeaturesControl::disable : instanceFeaturesControl::enable);
    }

    private InstanceFeaturesControl getInstanceFeaturesControl() {
        return this.backdoor.get().instanceFeaturesControl();
    }
}

