/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.backdoor.InstanceFeaturesControl;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableLazyLoadingActivityTabsRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(DisableLazyLoadingActivityTabsRule.class);
    private final Supplier<Backdoor> backdoor;

    public DisableLazyLoadingActivityTabsRule(Supplier<Backdoor> backdoorModule) {
        this.backdoor = backdoorModule;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (!DisableLazyLoadingActivityTabsRule.this.isLazyLoadingActivityTabsEnabled()) {
                        base.evaluate();
                    } else {
                        DisableLazyLoadingActivityTabsRule.this.setLazyLoadingActivityTabs(false);
                        base.evaluate();
                        DisableLazyLoadingActivityTabsRule.this.setLazyLoadingActivityTabs(true);
                    }
                }
                catch (Exception e) {
                    log.error("Could not disable lazy loading activity tabs!", (Throwable)e);
                    base.evaluate();
                }
            }
        };
    }

    private boolean isLazyLoadingActivityTabsEnabled() {
        InstanceFeaturesControl instanceFeaturesControl = this.getInstanceFeaturesControl();
        return !instanceFeaturesControl.isEnabled("com.atlassian.jira.lazyload.activity.tabs.disabled");
    }

    private void setLazyLoadingActivityTabs(boolean flag) {
        InstanceFeaturesControl instanceFeaturesControl = this.getInstanceFeaturesControl();
        Optional.of("com.atlassian.jira.lazyload.activity.tabs.disabled").ifPresent(flag ? instanceFeaturesControl::disable : instanceFeaturesControl::enable);
    }

    private InstanceFeaturesControl getInstanceFeaturesControl() {
        return this.backdoor.get().instanceFeaturesControl();
    }
}

