/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.TestAnnotationsExtractor;
import com.meterware.httpunit.HttpUnitOptions;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class HttpUnitConfigurationRule
implements TestRule {
    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                HttpUnitOptions.reset();
                HttpUnitConfigurationRule.this.overrideHttpUnitSettings(description);
                try {
                    statement.evaluate();
                }
                finally {
                    Defaults.restoreDefaults();
                }
            }
        };
    }

    private void overrideHttpUnitSettings(Description description) {
        HttpUnitConfigurationRule.overrideHttpUnitSettings(new TestAnnotationsExtractor(description).findAnnotationFor(HttpUnitConfiguration.class).orElseGet(() -> Defaults.getDefaults()));
    }

    public static void restoreDefaults() {
        HttpUnitOptions.reset();
        Defaults.restoreDefaults();
    }

    private static void overrideHttpUnitSettings(HttpUnitConfiguration configuration) {
        if (configuration.characterSet().isEmpty()) {
            HttpUnitOptions.resetDefaultCharacterSet();
        } else {
            HttpUnitOptions.setDefaultCharacterSet((String)configuration.characterSet());
        }
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)configuration.throwOnErrorStatus());
        HttpUnitOptions.setScriptingEnabled((boolean)configuration.enableScripting());
        HttpUnitOptions.setExceptionsThrownOnScriptError((boolean)configuration.throwOnScriptError());
    }

    @HttpUnitConfiguration
    private static class Defaults {
        private Defaults() {
        }

        public static void restoreDefaults() {
            HttpUnitConfigurationRule.overrideHttpUnitSettings(Defaults.getDefaults());
        }

        private static HttpUnitConfiguration getDefaults() {
            return Defaults.class.getAnnotation(HttpUnitConfiguration.class);
        }
    }
}

