/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JiraRestClientSupplier
implements TestRule,
Supplier<JiraRestClient> {
    private final Supplier<URI> serverUriSupplier;
    private Optional<JiraRestClient> jiraRestClient = Optional.empty();
    private final String username;
    private final String password;

    public JiraRestClientSupplier(Supplier<JIRAEnvironmentData> environmentDataSupplier) {
        this.serverUriSupplier = () -> this.getUri(environmentDataSupplier);
        this.username = "admin";
        this.password = "admin";
    }

    public JiraRestClientSupplier(Supplier<JIRAEnvironmentData> environmentDataSupplier, String username, String password) {
        this.serverUriSupplier = () -> this.getUri(environmentDataSupplier);
        this.username = username;
        this.password = password;
    }

    private URI getUri(Supplier<JIRAEnvironmentData> environmentDataSupplier) {
        try {
            return environmentDataSupplier.get().getBaseUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JiraRestClient get() {
        this.jiraRestClient = Optional.of(this.jiraRestClient.orElseGet(this::createClient));
        return this.jiraRestClient.get();
    }

    private JiraRestClient createClient() {
        return new AsynchronousJiraRestClientFactory().createWithBasicHttpAuthentication(this.serverUriSupplier.get(), this.username, this.password);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    JiraRestClientSupplier.this.jiraRestClient.ifPresent(IOUtils::closeQuietly);
                }
            }
        };
    }
}

