/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.TestAnnotationsExtractor;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoginAsRule
implements TestRule {
    private final Supplier<Navigation> navigationSupplier;
    private boolean loggedIn = false;

    public LoginAsRule(Supplier<Navigation> navigationSupplier) {
        this.navigationSupplier = navigationSupplier;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LoginAsRule.this.tryLogIn(description);
                base.evaluate();
                LoginAsRule.this.tryLogOut();
            }
        };
    }

    public void tryLogIn(Description description) {
        new TestAnnotationsExtractor(description).findAnnotationFor(LoginAs.class).ifPresent(this::loginAsByAnnotation);
    }

    private void loginAsByAnnotation(LoginAs loginAs) {
        if (loginAs != null) {
            if (loginAs.user() == null) {
                throw new IllegalStateException("You must specify user");
            }
            this.navigationSupplier.get().login(loginAs.user());
            this.loggedIn = true;
        }
    }

    private void tryLogOut() {
        if (this.loggedIn) {
            this.navigationSupplier.get().logout();
        }
    }
}

