/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.OutgoingMailControl;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.util.Supplier;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class OutgoingMailEventQueueRule
extends TestWatcher {
    private Supplier<OutgoingMailControl> outgoingMailControl;

    OutgoingMailEventQueueRule(Supplier<OutgoingMailControl> outgoingMailControl) {
        this.outgoingMailControl = outgoingMailControl;
    }

    protected void starting(Description description) {
        if (this.shouldFire(description)) {
            this.outgoingMailControl.get().enable();
            this.outgoingMailControl.get().clearMessages();
        }
    }

    protected void finished(Description description) {
        if (this.shouldFire(description)) {
            this.outgoingMailControl.get().disable();
        }
    }

    private boolean shouldFire(Description description) {
        return description.getAnnotation(MailTest.class) != null || description.getTestClass().getAnnotation(MailTest.class) != null;
    }

    public OutgoingMailControl getOutgoingMailControl() {
        return this.outgoingMailControl.get();
    }
}

