/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import javax.ws.rs.WebApplicationException;
import org.apache.log4j.Logger;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RerunIfFailedGlobalRule
implements TestRule {
    public static final int DEFAULT_MAX_RETRIES = 4;
    private static final Logger log = Logger.getLogger(RerunIfFailedGlobalRule.class);

    public Statement apply(final Statement base, final Description description) {
        if (System.getProperty("disableRerunIfFailedGlobalRule") != null) {
            return base;
        }
        final int maxRetries = Integer.getInteger("rerunIfFailedGlobalRuleMaxRetries", 4);
        return new Statement(){

            public void evaluate() throws Throwable {
                int tries = 0;
                while (true) {
                    log.info((Object)String.format("Executing %s - attempt %d of %d", RerunIfFailedGlobalRule.this.formatTestDescription(description), ++tries, maxRetries + 1));
                    try {
                        base.evaluate();
                    }
                    catch (Throwable t) {
                        if (t instanceof WebApplicationException) {
                            throw t;
                        }
                        if (t instanceof AssumptionViolatedException) {
                            throw t;
                        }
                        if (tries > maxRetries) {
                            log.warn((Object)String.format("%s failed %s time(s) - giving up", RerunIfFailedGlobalRule.this.formatTestDescription(description), tries));
                            throw t;
                        }
                        log.warn((Object)String.format("%s failed %s time(s) - rerunning it", RerunIfFailedGlobalRule.this.formatTestDescription(description), tries));
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private String formatTestDescription(Description description) {
        return description.getClassName() + "#" + description.getMethodName();
    }
}

