/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.AttachmentFileControl;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.CleanAttachmentsRule;
import com.atlassian.jira.functest.rule.CleanDirectoryRule;
import com.atlassian.jira.functest.rule.CopyAttachmentsRule;
import com.atlassian.jira.functest.rule.EnableAttachmentsRule;
import com.atlassian.jira.functest.rule.TemporaryFileRule;
import com.atlassian.jira.testkit.client.AttachmentsControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.io.File;
import java.util.function.Supplier;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class Rules {
    public static TestRule prepareAttachments(Supplier<JIRAEnvironmentData> environmentDataSupplier, Supplier<Backdoor> backdoorSupplier, String sourceSubPath) {
        Supplier<AttachmentsControl> attachmentsControlSupplier = () -> ((Backdoor)backdoorSupplier.get()).attachments();
        Supplier<AttachmentFileControl> attachmentFileControlSupplier = () -> ((Backdoor)backdoorSupplier.get()).attachmentFile();
        return Rules.chain().around(Rules.enableAttachments(attachmentsControlSupplier)).around(Rules.cleanAttachments(attachmentFileControlSupplier)).around(Rules.copyAttachments(environmentDataSupplier, attachmentFileControlSupplier, sourceSubPath));
    }

    public static RuleChain chain() {
        return RuleChain.emptyRuleChain();
    }

    public static TestRule enableAttachments(Supplier<AttachmentsControl> attachmentsControlSupplier) {
        return new EnableAttachmentsRule(attachmentsControlSupplier);
    }

    public static TestRule cleanAttachments(Supplier<AttachmentFileControl> attachmentFileControlSupplier) {
        return new CleanAttachmentsRule(attachmentFileControlSupplier);
    }

    public static TestRule copyAttachments(Supplier<JIRAEnvironmentData> environmentDataSupplier, Supplier<AttachmentFileControl> attachmentFileControlSupplier, String sourceSubPath) {
        return new CopyAttachmentsRule(environmentDataSupplier, attachmentFileControlSupplier, sourceSubPath);
    }

    public static TestRule cleanDirectory(Supplier<File> directory) {
        return new CleanDirectoryRule(directory);
    }

    public static TemporaryFileRule temporaryFile() {
        return new TemporaryFileRule();
    }
}

