/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.BackdoorModule;
import com.atlassian.jira.functest.framework.SkipSetBaseUrl;
import com.atlassian.jira.functest.framework.TestAnnotationsExtractor;
import com.atlassian.jira.functest.rule.StatementDecorator;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SetBaseUrlRule
implements TestRule {
    private final BackdoorModule backdoorModule;

    public SetBaseUrlRule(BackdoorModule backdoorModule) {
        this.backdoorModule = backdoorModule;
    }

    public Statement apply(Statement base, Description description) {
        return this.isSkipSetBaseUrlAnnotationPresent(description) ? base : new StatementDecorator(base, this::setBaseUrl);
    }

    private boolean isSkipSetBaseUrlAnnotationPresent(Description description) {
        return new TestAnnotationsExtractor(description).findAnnotationFor(SkipSetBaseUrl.class).isPresent();
    }

    private void setBaseUrl() {
        String baseUrl = this.backdoorModule.getEnvironmentData().getBaseUrl().toExternalForm();
        FuncTestOut.log((Object)("Setting base url to: " + baseUrl));
        this.backdoorModule.getBackdoor().applicationProperties().setString("jira.baseurl", baseUrl);
    }
}

