/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.hallelujah;

import com.atlassian.buildeng.hallelujah.api.client.AbstractClientListener;
import com.atlassian.buildeng.hallelujah.api.client.ClientListener;
import com.atlassian.buildeng.hallelujah.api.client.ClientTestCaseProvider;
import com.atlassian.buildeng.hallelujah.api.client.ClientTestCaseResultCollector;
import com.atlassian.buildeng.hallelujah.api.client.ClientTestCaseRunner;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseName;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;
import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.WebTestListener;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.hallelujah.HallelujahTestFailureException;
import com.atlassian.jira.util.dbc.Assertions;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class WebTestListenerToClientListenerAdapter
extends AbstractClientListener
implements ClientListener {
    private WebTestListener listener;

    public WebTestListenerToClientListenerAdapter(WebTestListener listener) {
        this.listener = Assertions.notNull(listener);
    }

    public boolean onPass(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseResult result) {
        this.listener.testFinished(WebTestClientDescription.fromTestCaseName(result.testCaseName));
        return true;
    }

    public boolean onFailure(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseResult result) {
        this.listener.testFailure(WebTestClientDescription.fromTestCaseName(result.testCaseName), new HallelujahTestFailureException(result.failure.message, result.failure));
        this.listener.testFinished(WebTestClientDescription.fromTestCaseName(result.testCaseName));
        return true;
    }

    public boolean onError(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseResult result) {
        this.listener.testError(WebTestClientDescription.fromTestCaseName(result.testCaseName), new HallelujahTestFailureException(result.error.message, result.failure));
        this.listener.testFinished(WebTestClientDescription.fromTestCaseName(result.testCaseName));
        return true;
    }

    public void onFinish(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector) {
        this.listener.suiteFinished(WebTestClientDescription.fakeSuite());
    }

    public void onStart(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector) {
        this.listener.suiteStarted(WebTestClientDescription.fakeSuite());
    }

    public boolean onTestStart(ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseResultCollector clientTestCaseResultCollector, TestCaseName testCaseName) {
        this.listener.testStarted(WebTestClientDescription.fromTestCaseName(testCaseName));
        return true;
    }

    public static class WebTestClientDescription
    implements WebTestDescription {
        private final Class<?> testClass;
        private final TestCaseName testCaseName;

        public static WebTestClientDescription fromTestCaseName(TestCaseName name) {
            return new WebTestClientDescription(name);
        }

        public static WebTestDescription fakeSuite() {
            return new WebTestClientDescription();
        }

        public WebTestClientDescription(TestCaseName testCaseName) {
            try {
                this.testCaseName = testCaseName;
                this.testClass = Class.forName(testCaseName.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public WebTestClientDescription() {
            this.testClass = this.getClass();
            this.testCaseName = new TestCaseName(this.testClass().getName(), "");
        }

        @Override
        public String name() {
            return this.testCaseName.className + "." + this.testCaseName.methodName;
        }

        @Override
        public String className() {
            return this.testCaseName.className;
        }

        @Override
        public String methodName() {
            return this.testCaseName.methodName;
        }

        @Override
        public Class<?> testClass() {
            return this.testClass;
        }

        @Override
        public Iterable<Annotation> annotations() {
            return Arrays.asList(this.testClass.getAnnotations());
        }

        @Override
        public Set<Category> categories() {
            return Category.fromAnnotation(this.testClass.getAnnotation(WebTest.class));
        }

        @Override
        public boolean isTest() {
            return true;
        }

        @Override
        public boolean isSuite() {
            return false;
        }

        @Override
        public int testCount() {
            return 1;
        }

        @Override
        public Iterable<WebTestDescription> children() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebTestClientDescription that = (WebTestClientDescription)o;
            if (this.testCaseName != null ? !this.testCaseName.equals((Object)that.testCaseName) : that.testCaseName != null) {
                return false;
            }
            return !(this.testClass != null ? !this.testClass.equals(that.testClass) : that.testClass != null);
        }

        public int hashCode() {
            int result = this.testClass != null ? this.testClass.hashCode() : 0;
            result = 31 * result + (this.testCaseName != null ? this.testCaseName.hashCode() : 0);
            return result;
        }
    }
}

