/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.NumberAssertions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Iterator;
import java.util.NavigableMap;

public class CompositeClock
implements Clock {
    private final NavigableMap<Integer, Clock> clocks = Maps.newTreeMap();
    private int currentCall = 1;

    public CompositeClock(Clock initialClock) {
        this.clocks.put(1, Assertions.notNull("initialClock", initialClock));
    }

    public CompositeClock addClock(int startFromCall, Clock clock) {
        NumberAssertions.greaterThan("startFromCall", startFromCall, (Integer)this.clocks.lastKey());
        this.clocks.put(startFromCall, clock);
        return this;
    }

    public Date getCurrentDate() {
        Date answer = this.findClock().getCurrentDate();
        ++this.currentCall;
        return answer;
    }

    private Clock findClock() {
        int startFromCall;
        if (this.currentCall >= (Integer)this.clocks.lastKey()) {
            return this.clocks.lastEntry().getValue();
        }
        int clockKey = (Integer)this.clocks.firstKey();
        Iterator iterator = this.clocks.keySet().iterator();
        while (iterator.hasNext() && this.currentCall >= (startFromCall = ((Integer)iterator.next()).intValue())) {
            clockKey = startFromCall;
        }
        return (Clock)this.clocks.get(clockKey);
    }
}

