/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CsvUtils {
    private CsvUtils() {
    }

    public static String removeColumnsThatStartWith(String csvString, String prefix) {
        String[] rows = csvString.split("\n");
        String[] headerColumns = rows[0].split(",");
        List<Integer> columnNumbersToRemove = CsvUtils.calculateColumnNumbersThatStartWith(headerColumns, prefix);
        List<String> squashedRows = CsvUtils.squashMultilineRows(rows, headerColumns.length);
        List<String> clearedRows = CsvUtils.removeColumns(squashedRows, columnNumbersToRemove);
        return String.join((CharSequence)"", clearedRows);
    }

    private static List<String> removeColumns(List<String> rows, List<Integer> columnNumbersToRemove) {
        ArrayList<String> processedRows = new ArrayList<String>();
        rows.forEach(row -> {
            String[] columns = row.split(",");
            ArrayList<String> processedColumns = new ArrayList<String>();
            for (int i = 0; i < columns.length; ++i) {
                if (columnNumbersToRemove.contains(i)) continue;
                processedColumns.add(columns[i]);
            }
            processedRows.add(String.join((CharSequence)",", processedColumns));
        });
        return processedRows;
    }

    private static List<String> squashMultilineRows(String[] rows, int numberOfColumns) {
        ArrayList<String> squashedRows = new ArrayList<String>();
        for (int i = 0; i < rows.length; ++i) {
            int rowOffset = 0;
            int numberOfColumnsProcessed = 0;
            String row = "";
            do {
                String currentRow;
                if ((numberOfColumnsProcessed += StringUtils.countMatches((CharSequence)(currentRow = rows[i + rowOffset++]), (CharSequence)",")) <= numberOfColumns - 1) {
                    row = row.concat(currentRow).concat("\n");
                    continue;
                }
                --rowOffset;
            } while (numberOfColumnsProcessed <= numberOfColumns - 1 && i + rowOffset < rows.length);
            i += rowOffset - 1;
            squashedRows.add(row);
        }
        return squashedRows;
    }

    private static List<Integer> calculateColumnNumbersThatStartWith(String[] columns, String prefix) {
        ArrayList<Integer> matchingColumns = new ArrayList<Integer>();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].startsWith(prefix)) continue;
            matchingColumns.add(i);
        }
        return matchingColumns;
    }
}

