/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.Clock;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrictMockClock
implements Clock {
    private static final Logger log = LoggerFactory.getLogger(StrictMockClock.class);
    private final List<Long> times;
    private int current = 0;

    public StrictMockClock(List<Long> times) {
        this.times = ImmutableList.copyOf(times);
    }

    public StrictMockClock(Long ... times) {
        this.times = Arrays.asList(times);
    }

    public List<Long> times() {
        return ImmutableList.copyOf(this.times);
    }

    public long first() {
        if (this.times.isEmpty()) {
            return -1L;
        }
        return this.times.get(0);
    }

    public long last() {
        if (this.times.isEmpty()) {
            return -1L;
        }
        return this.times.get(this.times.size() - 1);
    }

    public Date getCurrentDate() {
        log.debug("#getCurrentDate: times=" + this.times + ",current=" + this.current);
        if (this.current >= this.times.size()) {
            throw new IllegalStateException("Called too many times, only supports " + this.times.size() + " invocations");
        }
        return new Date(this.times.get(this.current++));
    }
}

