/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.dbc;

import org.apache.commons.lang3.StringUtils;

public final class Assertions {
    private Assertions() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <T> T notNull(String name, T notNull) throws IllegalArgumentException {
        if (notNull == null) {
            throw new NullArgumentException(name);
        }
        return notNull;
    }

    public static <T> T notNull(T notNull) throws IllegalArgumentException {
        if (notNull == null) {
            throw new NullArgumentException("parameter");
        }
        return notNull;
    }

    public static <C extends Iterable<?>> C containsNoNulls(String name, C containsNoNulls) throws IllegalArgumentException {
        Assertions.notNull(name, containsNoNulls);
        int i = 0;
        for (Object item : containsNoNulls) {
            if (item == null) {
                throw new NullArgumentException(name + "[" + i + "]");
            }
            ++i;
        }
        return containsNoNulls;
    }

    public static String notBlank(String name, String string) throws IllegalArgumentException {
        Assertions.notNull(name, string);
        if (string.trim().length() == 0) {
            throw new BlankStringArgumentException(name);
        }
        return string;
    }

    public static <C extends Iterable<String>> C containsNoBlanks(String name, C stringsNotBlank) {
        Assertions.notNull(name, stringsNotBlank);
        int i = 0;
        for (String item : stringsNotBlank) {
            if (StringUtils.isBlank((CharSequence)item)) {
                throw new BlankStringArgumentException(name + "[" + i + "]");
            }
            ++i;
        }
        return stringsNotBlank;
    }

    public static void is(String name, boolean condition) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(name);
        }
    }

    public static void is(boolean condition) throws IllegalArgumentException {
        Assertions.is("condition", condition);
    }

    public static void not(String name, boolean condition) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(name);
        }
    }

    public static void stateTrue(String name, boolean condition) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(name);
        }
    }

    public static <T> T stateNotNull(String name, T notNull) {
        if (notNull == null) {
            throw new NullStateException(name);
        }
        return notNull;
    }

    public static <T> T equals(String name, T expected, T got) throws IllegalArgumentException {
        if (!expected.equals(got)) {
            throw new IllegalArgumentException(name + ". Expected:" + expected + " but got: " + got);
        }
        return got;
    }

    public static <T> T[] notEmpty(String name, T[] array) {
        Assertions.notNull(name, array);
        if (array.length == 0) {
            throw new IllegalArgumentException("Array <" + name + "> must not be empty");
        }
        return array;
    }

    static class NullStateException
    extends IllegalStateException {
        NullStateException(String name) {
            super(name + " should not be null!");
        }
    }

    static class NullArgumentException
    extends IllegalArgumentException {
        NullArgumentException(String name) {
            super(name + " should not be null!");
        }
    }

    static class BlankStringArgumentException
    extends IllegalArgumentException {
        BlankStringArgumentException(String name) {
            super(name + " should not be empty!");
        }
    }
}

