/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.email.EmailKit;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.google.common.collect.ImmutableList;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public abstract class AbstractSubscriptionEmailTest
extends EmailBaseFuncTestCase {
    private static final String VIEW_FILTER_REGEX = "issues/\\?filter=\\d+";
    private static final String VIEW_FILTER_REGEX_HTML = "issues/\\?filter=(3D)*\\d+";
    private static final String EDIT_FILTER_REGEX = "secure/EditSubscription\\!default.jspa\\?subId=\\d+&filterId=\\d+";
    private static final String EDIT_FILTER_REGEX_HTML = "secure/EditSubscription\\!default.jspa\\?subId=(3D)*\\d+&amp;filterId=(3D)*\\d+";
    private static final String TEXT_HEADER_REGEX = "Key\\s*Summary";
    private static final String[] HTML_TABLE_HEADER = new String[]{"Key", "Summary", "Assignee", "Reporter", "Status", "Created", "Updated", "Due"};
    @Inject
    private Assertions assertions;

    protected String assertTextMessageValid(MimeMessage message, FilterConfig config, String from, String to, String userName) throws Exception {
        this.assertMessageHeader(message, from, to, config);
        String body = GreenMailUtil.getBody((Part)message);
        body = AbstractSubscriptionEmailTest.assertTextMessageStart(body, config, userName);
        return AbstractSubscriptionEmailTest.assertIssuesInTextMessage(config, body);
    }

    protected String assertHtmlMessageValid(MimeMessage message, FilterConfig config, String from, String to, String userName) throws Exception {
        this.assertMessageHeader(message, from, to, config);
        String body = EmailKit.getBody((Part)message);
        body = AbstractSubscriptionEmailTest.assertHtmlMessageStart(body, config, userName);
        AbstractSubscriptionEmailTest.assertHtmlMessageFooter(body);
        return AbstractSubscriptionEmailTest.assertIssuesInHtmlMessage(config, body);
    }

    private void assertMessageHeader(MimeMessage message, String from, String to, FilterConfig filterConfig) throws Exception {
        this.assertEmailFromEquals(message, from);
        this.assertEmailToEquals(message, to);
        this.assertEmailSubjectEquals(message, "[JIRATEST] Subscription: " + filterConfig.getFilterName());
    }

    private static String assertTextMessageStart(String body, FilterConfig filterConfig, String userName) throws Exception {
        String text = body;
        AbstractSubscriptionEmailTest.assertNotStringContains(text, "<html>");
        text = AbstractSubscriptionEmailTest.assertStringContains(text, "Issue Subscription");
        String filterStr = "Filter: " + filterConfig.getFilterName() + ' ' + AbstractSubscriptionEmailTest.getFilterStatus(filterConfig);
        text = AbstractSubscriptionEmailTest.assertStringContains(text, filterStr);
        if (filterConfig.getFilterDescription() != null) {
            text = AbstractSubscriptionEmailTest.assertStringContains(text, filterConfig.getFilterDescription());
        }
        String subscriber = "Subscriber: " + userName;
        return AbstractSubscriptionEmailTest.assertStringContains(text, subscriber);
    }

    private static String assertHtmlMessageStart(String body, FilterConfig filterConfig, String username) {
        String text = body;
        AbstractSubscriptionEmailTest.assertStringContains(text, "<html");
        text = AbstractSubscriptionEmailTest.assertStringContains(text, "Issue Subscription");
        text = AbstractSubscriptionEmailTest.assertStringContains(text, "Filter");
        text = AbstractSubscriptionEmailTest.assertStringMatchesRegex(text, VIEW_FILTER_REGEX_HTML);
        text = AbstractSubscriptionEmailTest.assertStringContains(text, filterConfig.getFilterName());
        text = AbstractSubscriptionEmailTest.assertStringContains(text, AbstractSubscriptionEmailTest.getFilterStatus(filterConfig));
        return AbstractSubscriptionEmailTest.assertStringContains(text, username);
    }

    private static void assertHtmlMessageFooter(String body) {
        AbstractSubscriptionEmailTest.assertStringContains(body, "This message was sent by Atlassian Jira");
    }

    private static String assertIssuesInTextMessage(FilterConfig filterConfig, String body) {
        String text = body;
        if (filterConfig.getTotalIssues() > 0) {
            text = AbstractSubscriptionEmailTest.assertStringMatchesRegex(text, TEXT_HEADER_REGEX);
            Iterator<Integer> issuesIter = filterConfig.getIssueIterator();
            while (issuesIter.hasNext()) {
                Integer issue = issuesIter.next();
                String issueKey = filterConfig.getProjectKey() + '-' + issue;
                text = AbstractSubscriptionEmailTest.assertStringContains(text, issueKey);
                String url = "browse/" + issueKey;
                text = AbstractSubscriptionEmailTest.assertStringContains(text, url);
            }
        } else {
            AbstractSubscriptionEmailTest.assertNotStringMatchesRegex(text, TEXT_HEADER_REGEX);
        }
        AbstractSubscriptionEmailTest.assertNotStringMatchesRegex(text, filterConfig.getProjectKey() + "-\\d+");
        return text;
    }

    private static String assertIssuesInHtmlMessage(FilterConfig filterConfig, String body) {
        String text = body;
        if (filterConfig.getTotalIssues() > 0) {
            text = AbstractSubscriptionEmailTest.assertStringContains(text, HTML_TABLE_HEADER);
            Iterator<Integer> issuesIter = filterConfig.getIssueIterator();
            while (issuesIter.hasNext()) {
                Integer issue = issuesIter.next();
                String issueKey = filterConfig.getProjectKey() + '-' + issue;
                String url = "browse/" + issueKey;
                text = AbstractSubscriptionEmailTest.assertStringContains(text, url);
                text = AbstractSubscriptionEmailTest.assertStringContains(text, url);
                text = AbstractSubscriptionEmailTest.assertStringContains(text, issueKey);
                text = AbstractSubscriptionEmailTest.assertStringContains(text, url);
            }
        } else {
            AbstractSubscriptionEmailTest.assertNotStringContains(text, HTML_TABLE_HEADER);
        }
        AbstractSubscriptionEmailTest.assertNotStringMatchesRegex(text, filterConfig.getProjectKey() + "-\\d+");
        return text;
    }

    protected static String assertPartialLinkText(FilterConfig filterConfig, String body) {
        String text = body;
        String partialString = "Displaying " + filterConfig.getReturnedIssues() + " of " + filterConfig.getTotalIssues() + " matched issues. You may view all matched issues";
        text = AbstractSubscriptionEmailTest.assertStringContains(text, partialString);
        return AbstractSubscriptionEmailTest.assertStringMatchesRegex(text, VIEW_FILTER_REGEX);
    }

    protected static String assertPartialLinkHtml(FilterConfig filterConfig, String body) {
        String text = body;
        String partialString = "Displaying " + filterConfig.getReturnedIssues() + " of " + filterConfig.getTotalIssues() + " matched issues. You may view all matched issues";
        text = AbstractSubscriptionEmailTest.assertStringContains(text, partialString);
        return AbstractSubscriptionEmailTest.assertStringMatchesRegex(text, VIEW_FILTER_REGEX_HTML);
    }

    protected static void assertNotPartialLink(String body) {
        AbstractSubscriptionEmailTest.assertNotStringContains(body, "You may view all matched issues");
    }

    protected static String assertEditLinkText(String body) {
        String text = body;
        text = AbstractSubscriptionEmailTest.assertStringContains(text, "You may edit this subscription");
        return AbstractSubscriptionEmailTest.assertStringMatchesRegex(text, EDIT_FILTER_REGEX);
    }

    protected static String assertEditLinkHtml(String body) {
        String text = body;
        text = AbstractSubscriptionEmailTest.assertStringContains(text, "You may edit this subscription");
        return AbstractSubscriptionEmailTest.assertStringMatchesRegex(text, EDIT_FILTER_REGEX_HTML);
    }

    protected static void assertNotEditLink(String body) {
        AbstractSubscriptionEmailTest.assertNotStringContains(body, "You may edit this subscription");
    }

    private static void assertNotStringContains(String text, String substring) {
        Assert.assertThat((Object)text, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)substring)));
    }

    private static void assertNotStringContains(String text, String ... substrings) {
        String s = text;
        for (String substring : substrings) {
            if ((s = AbstractSubscriptionEmailTest.findStringInString(s, substring)) != null) continue;
            return;
        }
        Assert.fail((String)("Found strings '" + Arrays.asList(substrings).toString() + "' in text."));
    }

    private static String assertStringContains(String text, String substring) {
        String result = AbstractSubscriptionEmailTest.findStringInString(text, substring);
        Assert.assertNotNull((String)("Unable to find string '" + substring + "' in " + text), (Object)result);
        return result;
    }

    private static String assertStringContains(String text, String ... substrings) {
        String s = text;
        for (String substring : substrings) {
            s = AbstractSubscriptionEmailTest.assertStringContains(s, substring);
        }
        return s;
    }

    @Nullable
    private static String findStringInString(String haystack, String needle) {
        int pos = haystack.indexOf(needle);
        if (pos < 0) {
            return null;
        }
        return haystack.substring(pos + needle.length());
    }

    private static String assertStringMatchesRegex(String text, String regex) {
        String result = AbstractSubscriptionEmailTest.findRegexInString(text, regex);
        Assert.assertNotNull((String)("Unable to find regex '" + regex + "' in string '" + text + "'."), (Object)result);
        return result;
    }

    private static void assertNotStringMatchesRegex(String text, String regex) {
        if (AbstractSubscriptionEmailTest.findRegexInString(text, regex) != null) {
            Assert.fail((String)("The regular expression '" + regex + "' should not match the string '" + text + "'."));
        }
    }

    @Nullable
    private static String findRegexInString(String text, String regex) {
        Pattern pattern = Pattern.compile(regex, 8);
        java.util.regex.Matcher match = pattern.matcher(text);
        return match.find() ? text.substring(match.end()) : null;
    }

    private static String getFilterStatus(FilterConfig filterConfig) {
        String status = filterConfig.isPaged() ? "(" + filterConfig.getReturnedIssues() + " of " + filterConfig.getTotalIssues() + " issues)" : (filterConfig.getTotalIssues() == 1 ? "(" + filterConfig.getTotalIssues() + " issue)" : "(" + filterConfig.getTotalIssues() + " issues)");
        return status;
    }

    private void gotoSubscribeFilter(FilterConfig config) {
        this.navigation.manageFilters().allFilters();
        this.tester.clickLink("subscribe_" + config.getFilterName());
    }

    protected void subscribeToFilterAndRun(FilterConfig config, String group) {
        this.gotoSubscribeFilter(config);
        if (group != null) {
            this.tester.setFormElement("groupName", group);
        }
        this.tester.setFormElement("emailOnEmpty", "true");
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 5);
        String cronExpr = "0 0 0 1 1 ? " + calendar.get(1);
        this.tester.setFormElement("filter.subscription.prefix.dailyWeeklyMonthly", "advanced");
        this.tester.setFormElement("filter.subscription.prefix.cronString", cronExpr);
        this.tester.submit();
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header h1"), config.getFilterName());
        this.tester.assertTextPresent(cronExpr);
        this.tester.clickLinkWithText("Run now");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header h1"), config.getFilterName());
        this.tester.assertTextPresent(cronExpr);
    }

    protected static class CountingIterator
    implements Iterator<Integer> {
        private int current;
        private final int endRange;
        private final int increment;

        public CountingIterator(int start, int length) {
            this.endRange = start + length;
            this.current = start;
            this.increment = length < 0 ? -1 : 1;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endRange;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int ret = this.current;
            this.current += this.increment;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class FilterConfig {
        public static final FilterConfig ADMIN_FILTER_ZERO_RESULTS = new FilterConfig("ZeroFilter", "This is the zero filter.", "ProjectOne", "ONE", 0, 0);
        public static final FilterConfig ADMIN_FILTER_PARTIAL;
        public static final FilterConfig ADMIN_FILTER_FULL;
        public static final FilterConfig FRED_FILTER_ZERO_RESULTS;
        public static final FilterConfig FRED_FILTER_PARTIAL;
        public static final FilterConfig FRED_FILTER_FULL;
        private final String filterName;
        private final String filterDescription;
        private final int returnedIssues;
        private final int totalIssues;
        private final String projectName;
        private final String projectKey;

        protected FilterConfig(String filterName, String filterDescription, String projectName, String projectKey, int returnedIssues, int totalIssues) {
            this.projectName = projectName;
            this.projectKey = projectKey;
            this.filterName = filterName;
            this.filterDescription = filterDescription;
            this.returnedIssues = returnedIssues;
            this.totalIssues = totalIssues;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getFilterDescription() {
            return this.filterDescription;
        }

        public int getReturnedIssues() {
            return this.returnedIssues;
        }

        public int getTotalIssues() {
            return this.totalIssues;
        }

        public boolean isPaged() {
            return this.returnedIssues != this.totalIssues;
        }

        public Iterator<Integer> getIssueIterator() {
            return ImmutableList.of().iterator();
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        static {
            FRED_FILTER_ZERO_RESULTS = new FilterConfig("FredZeroFilter", "Fred Zero Filter for test.", "ProjectOne", "ONE", 0, 0);
            ADMIN_FILTER_PARTIAL = new FilterConfig("FilterOne", "Filter One Description.", "ProjectOne", "ONE", 200, 210){

                @Override
                public Iterator<Integer> getIssueIterator() {
                    return new CountingIterator(this.getTotalIssues(), -this.getReturnedIssues());
                }
            };
            ADMIN_FILTER_FULL = new FilterConfig("FilterTwo", null, "ProjectTwo", "TWO", 2, 2){

                @Override
                public Iterator<Integer> getIssueIterator() {
                    return new CountingIterator(1, this.getReturnedIssues());
                }
            };
            FRED_FILTER_PARTIAL = new FilterConfig("FredFilterOne", null, "ProjectOne", "ONE", 200, 210){

                @Override
                public Iterator<Integer> getIssueIterator() {
                    return new CountingIterator(1, this.getReturnedIssues());
                }
            };
            FRED_FILTER_FULL = new FilterConfig("FredFilterTwo", "This is a simple filter that will return all results.", "ProjectTwo", "TWO", 2, 2){

                @Override
                public Iterator<Integer> getIssueIterator() {
                    return new CountingIterator(this.getTotalIssues(), -this.getReturnedIssues());
                }
            };
        }
    }
}

