/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.cargo;

import com.atlassian.cargotestrunner.testrunner.Junit4TestRunner;
import com.atlassian.cargotestrunner.testrunner.TestRunner;
import com.atlassian.cargotestrunner.testrunner.TestRunnerConfig;
import com.atlassian.cargotestrunner.webtest.TestSetupCallbackFactory;
import com.atlassian.cargotestrunner.webtest.TestSetupRunnerCallbackFactory;
import com.atlassian.jira.functest.framework.SuiteListenerWrapper;
import com.atlassian.jira.functest.framework.TomcatShutdownListener;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.AcceptanceTestHarness;
import com.atlassian.jira.webtests.cargo.JIRACallbackFactory;
import com.atlassian.jira.webtests.cargo.JiraRunnerCallbackFactory;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Runner;
import org.junit.runners.model.InitializationError;

public class CargoTestHarness
extends TestSuite {
    public static final String URL_PREFIX = "/atlassian-jira";
    public static final String DEFAULT_CONTAINERS_LOCATION = "src/etc/java/containers.properties";
    public static final String DEFAULT_WAR_LOCATION = "../../target/atlassian-jira";
    public static final String CONTAINER_LOCATION_PROPERTY = "jira.functest.containerproperties";
    public static final String WAR_LOCATION_PROPERTY = "jira.functest.warlocation";
    public static final String CONTAINERS_PROPERTY = "cargo.containers";
    public static final String DELETE_TEMP_DIR_PROPERTY = "cargo.container.deleteTempDirectory";
    public static final String JIRA_HOME_PROPERTY = "jira.functest.home";
    public static final String DEFAULT_JIRA_HOME = "target/jirahome/";
    public static final String JACOCO_AGENT_PROPERTY = "jacoco.agent";
    public static final String TEST_SUITE_CLASS = System.getProperty("atlassian.test.suite.class");

    public static Test suite() throws IOException {
        if (StringUtils.isEmpty((CharSequence)TEST_SUITE_CLASS)) {
            return CargoTestHarness.wrapWithCargoRunner(AcceptanceTestHarness::suite);
        }
        return CargoTestHarness.suite(CargoTestHarness.getTestSuiteClass(TEST_SUITE_CLASS));
    }

    private static Test wrapWithCargoRunner(Supplier<Test> testSuitSupplier) throws IOException {
        FuncTestOut.out.println("_________________________");
        FuncTestOut.out.println("JIRA CargoTestHarness has started...");
        FuncTestOut.out.println("_________________________");
        CargoTestHarness.printSystemPropertiesInEffect();
        CargoTestHarness.printEnvironmentInEffect();
        Properties containerProperties = CargoTestHarness.getProperties();
        File war = CargoTestHarness.initWarFile();
        Test testSuite = CargoTestHarness.suite(testSuitSupplier, war, containerProperties);
        int testCaseCount = testSuite.countTestCases();
        TestInformationKit.startTestSuite(testCaseCount);
        return new SuiteListenerWrapper(testSuite, new TomcatShutdownListener());
    }

    public static Test suite(Class<?> suiteClass) throws IOException {
        return CargoTestHarness.wrapWithCargoRunner(() -> CargoTestHarness.createSuite(suiteClass));
    }

    public static Runner cargoRunner(Runner testRunner) throws IOException, InitializationError {
        FuncTestOut.out.println("_________________________");
        FuncTestOut.out.println("JIRA CargoTestHarness has started...");
        FuncTestOut.out.println("_________________________");
        CargoTestHarness.printSystemPropertiesInEffect();
        CargoTestHarness.printEnvironmentInEffect();
        Properties containerProperties = CargoTestHarness.getProperties();
        File war = CargoTestHarness.initWarFile();
        Runner cargoRunner = Junit4TestRunner.cargoRunner((Runner)testRunner, (Properties)containerProperties, (TestSetupRunnerCallbackFactory)new JiraRunnerCallbackFactory(URL_PREFIX), (File)war);
        TestInformationKit.startTestSuite(cargoRunner.testCount());
        return cargoRunner;
    }

    private static void printSystemPropertiesInEffect() {
        Properties properties = System.getProperties();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : properties.keySet()) {
            keys.add((String)object);
        }
        Collections.sort(keys);
        FuncTestOut.out.println("The following (" + keys.size() + ") Java System properties are in effect");
        for (String string : keys) {
            String value = properties.getProperty(string);
            FuncTestOut.out.println("\t" + string + " : " + value);
        }
        FuncTestOut.out.println("_________________________");
    }

    private static void printEnvironmentInEffect() {
        Map<String, String> map = System.getenv();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        FuncTestOut.out.println("The following (" + keys.size() + ") environment variables are in effect");
        for (String key : keys) {
            String value = map.get(key);
            FuncTestOut.out.println("\t" + key + " : " + value);
        }
        FuncTestOut.out.println("_________________________");
    }

    protected static File initWarFile() throws IOException {
        String warLocation = System.getProperty(WAR_LOCATION_PROPERTY, DEFAULT_WAR_LOCATION);
        FuncTestOut.out.println("Using war from '" + warLocation + "'");
        File war = new File(warLocation);
        if (!war.exists()) {
            throw new RuntimeException("Could not find JIRA war at " + war.getCanonicalPath() + ".  Please ensure that the working directory is the functional test dir");
        }
        return war;
    }

    private static Collection<String> parseContainersList(String containersList) {
        StringTokenizer st = new StringTokenizer(containersList, ",", false);
        ArrayList<String> containers = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = StringUtils.trimToNull((String)st.nextToken());
            if (token == null) continue;
            containers.add(token);
        }
        return containers;
    }

    private static Test suite(Supplier<Test> suiteSupplier, File warLocation, Properties properties) throws IOException {
        return TestRunner.suite(Collections.singletonList(suiteSupplier.get()), (Properties)properties, (TestSetupCallbackFactory)new JIRACallbackFactory(URL_PREFIX), (File)warLocation, (TestRunnerConfig)new TestRunnerConfig(true, false, false));
    }

    private static Class<?> getTestSuiteClass(String testSuiteClass) {
        try {
            return Class.forName(testSuiteClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class: " + testSuiteClass, e);
        }
    }

    private static Test createSuite(Class<?> suiteClass) {
        try {
            return (Test)suiteClass.getMethod("suite", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            for (Throwable error = e; error != null; error = error.getCause()) {
                System.err.println(error.getMessage());
                error.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    protected static Properties getProperties() throws IOException {
        String containerPropertiesLocation = System.getProperty(CONTAINER_LOCATION_PROPERTY, DEFAULT_CONTAINERS_LOCATION);
        FuncTestOut.out.println("Using container properties from '" + containerPropertiesLocation + "'");
        File containerProperties = new File(containerPropertiesLocation);
        if (!containerProperties.exists()) {
            throw new RuntimeException("Could not find containers.properties at " + containerProperties.getCanonicalPath() + ".  Please ensure that the working directory is the functional test dir");
        }
        return CargoTestHarness.getProperties(containerProperties);
    }

    private static Properties getProperties(File containerProperties) throws IOException {
        Properties properties = new Properties();
        FileInputStream inStream = new FileInputStream(containerProperties);
        try {
            properties.load(inStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
        }
        Collection<String> containerIds = CargoTestHarness.getContainerNames(properties);
        CargoTestHarness.cleanTemp(properties, containerIds);
        CargoTestHarness.addCargoSettings(properties, containerIds);
        return properties;
    }

    private static void cleanTemp(Properties properties, Collection<String> containerIds) throws IOException {
        boolean clean = Boolean.parseBoolean(properties.getProperty(DELETE_TEMP_DIR_PROPERTY));
        for (String containerId : containerIds) {
            String httpPortPropertyName = "cargo." + containerId + ".port";
            File containerTempDirectory = new File(System.getProperty("java.io.tmpdir"), containerId + "_" + properties.getProperty(httpPortPropertyName));
            if (!containerTempDirectory.exists()) continue;
            if (clean) {
                FuncTestOut.out.println("Deleting temp directory " + containerTempDirectory);
                boolean deleted = FileUtils.deleteQuietly((File)containerTempDirectory);
                FuncTestOut.out.println("Temp Directory deleted: " + deleted);
                continue;
            }
            throw new IllegalStateException("File " + containerTempDirectory.getCanonicalPath() + " exists and property " + DELETE_TEMP_DIR_PROPERTY + " is not set.  Cargo will not be able to run.");
        }
    }

    private static void addCargoSettings(Properties properties, Collection<String> containerIds) {
        String home = properties.getProperty(JIRA_HOME_PROPERTY, DEFAULT_JIRA_HOME);
        File homeFile = new File(home).getAbsoluteFile();
        String jacocAgentSettings = System.getProperty(JACOCO_AGENT_PROPERTY, "");
        for (String containerId : containerIds) {
            String propertyName = "cargo." + containerId + ".jvmArgs";
            String vmArgs = properties.getProperty(propertyName, "");
            if (!vmArgs.contains("-Djava.home")) {
                vmArgs = vmArgs + " -Djira.home=\"" + homeFile.getPath() + "\"";
                properties.put(propertyName, vmArgs);
            }
            if (!Strings.isNullOrEmpty((String)jacocAgentSettings) && !vmArgs.contains(jacocAgentSettings)) {
                vmArgs = vmArgs + " " + jacocAgentSettings;
                properties.put(propertyName, vmArgs);
                FuncTestOut.out.println("Added code coverage tracking to container " + containerId + " with " + jacocAgentSettings);
            }
            if (vmArgs.contains("-Datlassian.allow.insecure.url.parameter.login")) continue;
            vmArgs = vmArgs + " -Datlassian.allow.insecure.url.parameter.login=true";
            properties.put(propertyName, vmArgs);
        }
    }

    private static Collection<String> getContainerNames(Properties serverProperties) {
        Collection<String> containerNames;
        String containersList = serverProperties.getProperty(CONTAINERS_PROPERTY);
        if (containersList == null) {
            FuncTestOut.out.println("Empty list of containerNames.  Please set property 'cargo.containers'");
            containerNames = Collections.emptyList();
        } else {
            containerNames = CargoTestHarness.parseContainersList(containersList);
        }
        if (containerNames.isEmpty()) {
            FuncTestOut.out.println("Empty list of containerNames.  Please set property 'cargo.containers'");
        }
        return containerNames;
    }
}

