/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.table;

import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class HtmlTable {
    private WebTable webTable;
    private Map<String, Integer> headingMap;
    private List<String> headingList;

    public HtmlTable(WebTable webTable) {
        Assertions.notNull("webTable", webTable);
        this.webTable = webTable;
    }

    public static HtmlTable newHtmlTable(WebTester tester, String tableID) {
        WebTable webTable = tester.getDialog().getWebTableBySummaryOrId(tableID);
        return new HtmlTable(webTable);
    }

    public Row getRow(int rowIndex) {
        return new Row(rowIndex);
    }

    public List<Row> getRows() {
        int rowCount = this.webTable.getRowCount();
        ArrayList<Row> rows = new ArrayList<Row>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    public Row findRowWhereCellEquals(int columnIndex, String cellValue) {
        for (int rowNum = 0; rowNum < this.webTable.getRowCount(); ++rowNum) {
            String value = this.webTable.getCellAsText(rowNum, columnIndex);
            if (value == null || !value.trim().equals(cellValue)) continue;
            return this.getRow(rowNum);
        }
        return null;
    }

    public Row findRowWhereCellStartsWith(int columnIndex, String prefix) {
        for (int rowNum = 0; rowNum < this.webTable.getRowCount(); ++rowNum) {
            String value = this.webTable.getCellAsText(rowNum, columnIndex);
            if (value == null || !value.trim().startsWith(prefix)) continue;
            return this.getRow(rowNum);
        }
        return null;
    }

    public boolean doesCellHaveText(int row, int col, String text) {
        String cellContent = this.webTable.getCellAsText(row, col);
        return cellContent.contains(text);
    }

    public int getRowCount() {
        return this.webTable.getRowCount();
    }

    private Map<String, Integer> getHeadingMap() {
        if (this.headingMap == null) {
            List<String> list = this.getHeadingList();
            this.headingMap = new HashMap<String, Integer>();
            for (int i = 0; i < list.size(); ++i) {
                this.headingMap.put(list.get(i), i);
            }
        }
        return this.headingMap;
    }

    private int getColumnIndexForHeading(String heading) {
        Integer columnIndex = this.getHeadingMap().get(heading);
        if (columnIndex == null) {
            throw new IllegalStateException("Column heading '" + heading + "' not found");
        }
        return columnIndex;
    }

    public List<String> getHeadingList() {
        if (this.headingList == null) {
            ImmutableList.Builder list = ImmutableList.builder();
            Row headerRow = this.getRow(0);
            for (int i = 0; i < this.webTable.getColumnCount(); ++i) {
                list.add((Object)headerRow.getCellAsText(i));
            }
            this.headingList = list.build();
        }
        return this.headingList;
    }

    public class Row {
        private final int rowIndex;

        Row(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public String getCellAsText(int cellIndex) {
            return TextKit.collapseWhitespace(HtmlTable.this.webTable.getCellAsText(this.rowIndex, cellIndex));
        }

        public String getCellForHeading(String heading) {
            return this.getCellAsText(HtmlTable.this.getColumnIndexForHeading(heading));
        }

        public Node getCellNodeForHeading(String heading) {
            return HtmlTable.this.webTable.getTableCell(this.rowIndex, HtmlTable.this.getColumnIndexForHeading(heading)).getDOM();
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }
}

