/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.webtests.util.ClassLocator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.runner.RunWith;

public final class TestClassUtils {
    private static final String FUNC_TEST_PACKAGE = "com.atlassian.jira.webtests.ztests";
    private static final Set<Class<?>> JUNIT5_TEST_ANNOTATIONS = new HashSet<Class>(Arrays.asList(org.junit.jupiter.api.Test.class, RepeatedTest.class, ParameterizedTest.class, TestFactory.class));
    private static final Predicate<Method> IS_TEST_METHOD = input -> Modifier.isPublic(input.getModifiers()) && input.getReturnType().equals(Void.TYPE) && input.getParameterTypes().length == 0 && input.getName().startsWith("test");

    private TestClassUtils() {
    }

    public static List<Class<?>> getTestClasses(String packageName, boolean recursive) {
        ClassLocator<Object> classLocator = ClassLocator.forAnyClass().setPackage(packageName).setAllowInner(true).setPredicate(TestPredicate.INSTANCE);
        if (!recursive) {
            classLocator.setLevel(0);
        }
        return classLocator.findClasses();
    }

    public static List<Class<? extends TestCase>> getJUnit3TestClasses(String packageName, boolean recursive) {
        ClassLocator<TestCase> classLocator = new ClassLocator<TestCase>(TestCase.class).setPackage(packageName).setAllowInner(true).setPredicate(JUnit3TestPredicate.getInstance());
        if (!recursive) {
            classLocator = classLocator.setLevel(0);
        }
        return classLocator.findClasses();
    }

    public static List<Class<?>> getJUnit4TestClasses(String packageName, boolean recursive) {
        return ClassLocator.forAnyClass().setPackage(packageName).setAllowInner(true).setPredicate(TestClassUtils::isJunit4TestClas).setLevel(recursive ? Integer.MAX_VALUE : 0).findClasses();
    }

    public static List<Class<?>> getJUnit5TestClasses(String packageName, boolean recursive) {
        return ClassLocator.forAnyClass().setPackage(packageName).setAllowInner(true).setPredicate(TestClassUtils::isJunit5TestClass).setLevel(recursive ? Integer.MAX_VALUE : 0).findClasses();
    }

    public static List<Class<? extends TestCase>> getJUnit3TestClasses(String packageName) {
        return TestClassUtils.getJUnit3TestClasses(packageName, true);
    }

    public static List<Class<? extends TestCase>> getAllFuncTests() {
        return TestClassUtils.getJUnit3TestClasses(FUNC_TEST_PACKAGE);
    }

    public static List<Method> getTestMethods(Class<? extends TestCase> testClass) {
        return new ArrayList<Method>(CollectionUtil.filter(Arrays.asList(testClass.getMethods()), IS_TEST_METHOD));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJunit5TestClass(Class<?> klazz) {
        if (klazz.getAnnotation(ExtendWith.class) != null) return true;
        if (Arrays.stream(klazz.getMethods()).flatMap(klazzMethod -> Arrays.stream(klazzMethod.getAnnotations())).map(Annotation::annotationType).anyMatch(JUNIT5_TEST_ANNOTATIONS::contains)) return true;
        if (!Arrays.stream(klazz.getClasses()).anyMatch(innerClass -> innerClass.isAnnotationPresent(Nested.class))) return false;
        return true;
    }

    public static boolean isJunit4TestClas(Class<?> klazz) {
        Method[] klazzMethods;
        boolean hasRunWith;
        boolean bl = hasRunWith = klazz.getAnnotation(RunWith.class) != null;
        if (hasRunWith) {
            return true;
        }
        for (Method klazzMethod : klazzMethods = klazz.getMethods()) {
            if (klazzMethod.getAnnotation(Test.class) == null) continue;
            return true;
        }
        return false;
    }

    private static final class TestPredicate
    implements Predicate<Class<?>> {
        static final TestPredicate INSTANCE = new TestPredicate();

        private TestPredicate() {
        }

        @Override
        public boolean evaluate(Class<?> input) {
            if (!this.hasTestName(input.getSimpleName())) {
                return false;
            }
            int modifiers = input.getModifiers();
            return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers);
        }

        private boolean hasTestName(String simpleName) {
            return simpleName.startsWith("Test") || simpleName.endsWith("Test");
        }
    }

    private static final class JUnit3TestPredicate
    implements Predicate<Class<? extends TestCase>> {
        private static final JUnit3TestPredicate INSTANCE = new JUnit3TestPredicate();

        public static JUnit3TestPredicate getInstance() {
            return INSTANCE;
        }

        private JUnit3TestPredicate() {
        }

        protected Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("I'm a singleton.");
        }

        @Override
        public boolean evaluate(Class<? extends TestCase> input) {
            int modifiers = input.getModifiers();
            return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers);
        }
    }
}

