/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util.mail;

import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.atlassian.jira.webtests.util.mail.MailService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.BindException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingMail
extends JFrame {
    private static final String DEFAULT_EMAIL_ADDRESS = "admin@example.com";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String POP3_PORT_LABEL_PREFIX = "POP3 port: ";
    private static final String SMTP_PORT_LABEL_PREFIX = "SMTP port: ";
    private static final String ACCOUNT_LABEL_PREFIX = "Account: ";
    private MailService mailService;
    private JLabel pop3PortLabel;
    private JLabel smtpPortLabel;
    private AbstractButton startButton;
    private AbstractButton stopButton;
    private AbstractButton testMessageButton;

    public SwingMail(String title) throws HeadlessException {
        super(title);
        Container pane = this.getContentPane();
        pane.setLayout(new FlowLayout());
        JPanel labelPane = new JPanel();
        ((Component)labelPane).setPreferredSize(new Dimension(315, 60));
        this.pop3PortLabel = new JLabel();
        this.smtpPortLabel = new JLabel();
        JLabel accountLabel = new JLabel();
        accountLabel.setText("Account: admin@example.com/admin/admin");
        labelPane.add(this.pop3PortLabel);
        labelPane.add(this.smtpPortLabel);
        labelPane.add(accountLabel);
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.testMessageButton = new JButton();
        pane.add(this.startButton);
        pane.add(this.stopButton);
        pane.add(this.testMessageButton);
        pane.add(labelPane);
        this.addHandlers();
        this.syncUI();
        this.pack();
        this.setVisible(true);
        System.out.println("Ready.");
    }

    private void addHandlers() {
        this.startButton.setAction(new AbstractAction("Start"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingMail.this.startService();
            }
        });
        this.stopButton.setAction(new AbstractAction("Stop"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingMail.this.stopService();
            }
        });
        this.testMessageButton.setAction(new AbstractAction("Send Test Message"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingMail.this.sendTestMessage();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingMail.this.shutdown();
            }
        });
    }

    private void shutdown() {
        this.stopService();
        System.out.println("Shutting down...");
        System.exit(0);
    }

    private void sendTestMessage() {
        if (this.mailService != null) {
            String subject = "SwingMail Test Message";
            String body = "Hi, I'm a test message from your mail service interface. If you're reading me your mail setup is good.";
            this.mailService.sendTextMessage(DEFAULT_EMAIL_ADDRESS, DEFAULT_EMAIL_ADDRESS, "SwingMail Test Message", body);
            System.out.println("Test message sent to admin@example.com.");
        }
    }

    private void startService() {
        try {
            this.mailService = new MailService((FuncTestLogger)new FuncTestLoggerImpl());
            this.mailService.configureAndStartGreenMail(JIRAServerSetup.SMTP_POP3);
            this.mailService.addUser(DEFAULT_EMAIL_ADDRESS, "admin", "admin");
            this.syncUI();
            System.out.println("Mail Service Started.");
        }
        catch (BindException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private void stopService() {
        if (this.mailService != null) {
            this.mailService.stop();
            this.syncUI();
            System.out.println("Mail Service Stopped.");
        }
    }

    private void syncUI() {
        boolean started = this.mailService != null && this.mailService.isRunning();
        this.pop3PortLabel.setText(POP3_PORT_LABEL_PREFIX + (started ? Integer.valueOf(this.mailService.getPop3Port()) : ""));
        this.smtpPortLabel.setText(SMTP_PORT_LABEL_PREFIX + (started ? Integer.valueOf(this.mailService.getSmtpPort()) : ""));
        this.startButton.setEnabled(!started);
        this.stopButton.setEnabled(started);
        this.testMessageButton.setEnabled(started);
    }

    public static void main(String[] args) {
        new SwingMail("mail");
    }
}

