/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
public class TestInternalServerError
extends BaseJiraFuncTest {
    private static final String ERRONEOUS_SERVLET_URL = "/plugins/servlet/functest-throw-exception";

    @Before
    public void setUp() {
        this.backdoor.server().recordLogs(true);
    }

    @After
    public void tearDown() {
        this.backdoor.server().recordLogs(false);
    }

    @Test
    public void testReferralIdVisibleInLogs() {
        this.tester.gotoPage(ERRONEOUS_SERVLET_URL);
        String errorId = this.tester.getDialog().getElement("log-referral-id").getTextContent();
        Assert.assertTrue((boolean)errorId.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        String logs = this.backdoor.server().getLogs();
        Assert.assertThat((Object)logs, (Matcher)Matchers.containsString((String)errorId));
    }

    @Test
    public void testLogSensitiveData() {
        String password = UUID.randomUUID().toString();
        this.tester.gotoPage("/plugins/servlet/functest-throw-exception?os_username=admin&os_password=" + password);
        String logs = this.backdoor.server().getLogs();
        Assert.assertThat((Object)logs, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)password)));
    }
}

