/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.SlowTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.IMPORT_EXPORT, Category.UPGRADE_TASKS})
@LoginAs(user="admin")
public class TestUpgradeExport
extends BaseJiraFuncTest {
    private static final String BUILD_NUMBER_PATTERN = "Build # +: (\\d+)";
    private static final String PATCHED_NUMBER_PATTERN = "jira\\.version\\.patched +: (\\d+)";
    @Inject
    private Administration administration;

    @Test
    @SlowTest
    public void testDataImport() {
        this.importDataFromFile("JiraSfAndSdExport_72002.zip");
        this.navigation.login("admin");
        File exportFile = this.administration.exportDataToFile("server_backup_export.xml");
        Assert.assertTrue((String)"Backup file does not exist", (boolean)exportFile.exists());
        Assert.assertTrue((String)"Can not read exported file", (boolean)exportFile.canRead());
        this.verifyExportedFile(exportFile);
    }

    private void verifyExportedFile(File exportFile) {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(exportFile);
            inputStream = zipFile.getInputStream(new ZipEntry("entities.xml"));
            String entitiesXmlContent = IOUtils.toString((InputStream)inputStream);
            Assert.assertFalse((String)"Exported file has no content.", (boolean)StringUtils.isBlank((CharSequence)entitiesXmlContent));
            Integer buildNumber = this.getBuildNumber(entitiesXmlContent, BUILD_NUMBER_PATTERN);
            Integer patchedNumber = this.getBuildNumber(entitiesXmlContent, PATCHED_NUMBER_PATTERN);
            Assert.assertEquals((String)String.format("Patched build number (%d) is not equal to the application's build number (%d)", patchedNumber, buildNumber), (Object)buildNumber, (Object)patchedNumber);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Exception occurred while trying to open export file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFile);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    private Integer getBuildNumber(String xmlFile, String stringPattern) {
        Pattern pattern = Pattern.compile(stringPattern);
        Matcher matcher = pattern.matcher(xmlFile);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(1));
        }
        throw new IllegalStateException("Can not find build number for pattern " + stringPattern);
    }

    private void importDataFromFile(String fileName) {
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + fileName);
        this.copyFileToJiraImportDirectory(file);
        this.getTester().gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getTester().setWorkingForm("restore-xml-data-backup");
        this.getTester().setFormElement("filename", fileName);
        this.getTester().setFormElement("license", LicenseKeys.COMMERCIAL_DC.getLicenseString());
        this.getTester().submit();
        this.administration.waitForRestore();
        this.getTester().assertTextPresent("Your import has been successful");
        this.getTester().assertTextNotPresent("NullPointerException");
    }

    private void copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
    }
}

