/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@RestoreBlankInstance
public class TestAdminSectionVisibility
extends BaseJiraFuncTest {
    private static final String NOTSYSADMIN_USERNAME = "notsysadmin";

    @Before
    public void setUp() {
        this.backdoor.getTestkit().usersAndGroups().addGroup("notsysadmins_group");
        this.backdoor.getTestkit().usersAndGroups().addUser(NOTSYSADMIN_USERNAME);
        this.backdoor.getTestkit().usersAndGroups().addUserToGroup(NOTSYSADMIN_USERNAME, "notsysadmins_group");
        this.backdoor.getTestkit().permissions().addGlobalPermission(0, "notsysadmins_group");
        this.backdoor.getTestkit().auditing().clearAllRecords();
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeBackupDataPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("backup_data");
        this.tester.assertTextPresent("Backup Jira data");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeRestoreDataPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("restore_data");
        this.tester.assertTextPresent("Restore Jira data from Backup");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeListenersPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("listeners");
        this.tester.assertTextPresent("Listeners are used for performing certain actions");
        this.tester.clickLinkWithText("Built-in Listeners");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeServicesPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("services");
        this.tester.assertTextPresent("Add a new service");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeOutgoingMailPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("outgoing_mail");
        this.tester.assertTextPresent("Outgoing mail");
        this.tester.assertTextPresent("SMTP Mail Server");
        this.tester.clickLinkWithText("Configure new SMTP mail server");
        this.tester.assertTextPresent("Use this page to add a new SMTP mail server");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeIncomingMailPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("incoming_mail");
        this.tester.assertTextPresent("Incoming mail");
        this.tester.assertTextPresent("Mail servers");
        this.tester.clickLinkWithText("Add mail server");
        this.tester.assertTextPresent("Use this page to add a new mail server so that Jira can retrieve mail from it.");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeWorkflowsPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.clickLink("workflows");
        this.tester.assertLinkPresentWithText("Import Workflow");
        this.tester.assertLinkPresentWithText("Import XML");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeAttachmentsPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("attachments");
        this.tester.assertTextPresent("Check and configure your attachment storage.");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeEditConfigurationPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("scheduler_details");
        this.tester.assertTextPresent("View the properties of the Jira internal scheduler");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeIntegrationCheckerPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("integrity_checker");
        this.tester.assertTextPresent("Select one or more integrity checks from");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeLoggingProfilingPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("logging_profiling");
        this.tester.assertTextPresent("Mark Logs");
        this.tester.assertTextPresent("HTTP Access Logging");
        this.tester.assertTextPresent("SQL Logging");
        this.tester.assertTextPresent("Default Loggers");
    }

    @Test
    @LoginAs(user="admin")
    public void testSysAdminCanSeeViewProjectsPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.assertLinkPresent("view_projects");
    }

    @Test
    public void testAdminCantSeeProtectedPages() {
        this.navigation.login(NOTSYSADMIN_USERNAME);
        this.checkUrlForNoPerm("/secure/admin/XmlBackup!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/XmlRestore!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/IntegrityChecker!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ViewListeners!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ViewLogging.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ConfigureLogging!default.jspa?loggerName=root", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/SchedulerAdmin.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/workflows/ImportWorkflowFromXml!default.jspa", "a system administrator");
    }

    @Test
    @LoginAs(user="fred")
    public void testNonAdminCantSeeProtectedPages() {
        this.checkUrlForNoPerm("/secure/admin/OutgoingMailServers.jspa", "an administrator");
        this.checkUrlForNoPerm("/secure/admin/IncomingMailServers.jspa", "an administrator");
        this.checkUrlForNoPerm("/secure/admin/AddSmtpMailServer!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/XmlBackup!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/XmlRestore!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/IntegrityChecker!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ViewListeners!default.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ViewLogging.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ConfigureLogging!default.jspa?loggerName=root", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/SchedulerAdmin.jspa", "a system administrator");
        this.checkUrlForNoPerm("/secure/admin/jira/ViewServices!default.jspa", "an administrator");
        this.checkUrlForNoPerm("/secure/admin/workflows/ImportWorkflowFromXml!default.jspa", "a system administrator");
    }

    @Test
    public void testAdminCantSeeLinks() {
        this.navigation.login(NOTSYSADMIN_USERNAME);
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.assertLinkNotPresent("backup_data");
        this.tester.assertLinkNotPresent("restore_data");
        this.tester.assertLinkNotPresent("integrity_checker");
        this.tester.assertLinkNotPresent("license_details");
        this.tester.assertLinkNotPresent("listeners");
        this.tester.assertLinkNotPresent("logging_profiling");
        this.tester.assertLinkNotPresent("scheduler_details");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.clickLink("workflows");
        this.tester.assertLinkNotPresentWithText("Import XML");
    }

    @Test
    @LoginAs(user="fred")
    public void testNonAdminCantSeeLinks() {
        this.navigation.gotoAdmin();
        this.tester.assertTextPresent("You do not have the permissions to administer any projects, or there are none created.");
        this.tester.assertElementNotPresent("admin-nav-heading");
    }

    private void checkUrlForNoPerm(String url, String expectedPerm) {
        this.tester.gotoPage(url);
        this.tester.assertTextPresent("does not have permission to access this page.");
        this.tester.assertTextPresent("You must log in as " + expectedPerm + " to access this page.");
    }
}

