/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.AdvancedApplicationProperties;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestAdvancedApplicationProperties
extends BaseJiraFuncTest {
    private static final String SUBTASK_KEY = "jira.table.cols.subtasks";
    private static final String SUBTASK_COLUMN = "customfield_10000";
    @Inject
    private Administration administration;

    @Test
    public void testAdvancedSettings() {
        this.administration.restoreBlankInstance();
        AdvancedApplicationProperties properties = this.administration.advancedApplicationProperties();
        Assert.assertTrue((properties.getApplicationProperties().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSubTaskColumnsAreVisibleWithoutRestart() {
        this.administration.restoreData("TestAdvancedApplicationProperties.xml");
        AdvancedApplicationProperties properties = this.administration.advancedApplicationProperties();
        String subtaskColumns = properties.getApplicationProperty(SUBTASK_KEY);
        subtaskColumns = subtaskColumns + String.format(", %s", SUBTASK_COLUMN);
        properties.setApplicationProperty(SUBTASK_KEY, subtaskColumns);
        this.navigation.issue().viewIssue("HSP-1");
        this.getAssertions().assertNodeHasText(new CssLocator(this.tester, ".customfield_10000"), "You should see this in the subtask column view.");
    }

    @Test
    public void testJiraCharacterLimitDefaultValue() {
        this.administration.restoreBlankInstance();
        String defaultLimit = this.administration.advancedApplicationProperties().getApplicationProperty("jira.text.field.character.limit");
        Assert.assertThat((Object)defaultLimit, (Matcher)CoreMatchers.is((Object)"32767"));
    }
}

