/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS})
@LoginAs(user="admin")
public class TestApplicationRoleBasedPermissions
extends BaseJiraFuncTest {
    private static final String INACCESSIBLE_ISSUE_ID = "";
    private static final String APPLICATION_ROLE_ANY = "";
    private static final String SOFTWARE_ONLY_USER = "dev";
    private static final String CORE_ONLY_USER = "fred";
    private String issueKey;
    private String issueId;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance(LicenseKeys.MULTI_ROLE_DC);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY, "jira-users");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "A test issue!");
        this.issueKey = issue.key;
        this.issueId = issue.id;
    }

    @Test
    public void testAnyProjectRoleGrantsAccessToAnyLoggedInUser() {
        this.removeAllBrowsePermissions();
        this.assertIssueAccessDenied(this.issueKey);
        this.grantBrowseAccessToApplicationRole("");
        this.assertIssueCanBeAccessed(this.issueKey);
    }

    @Test
    public void testSpecificProjectRoleGrantsAccessToRoleMembers() {
        this.setupSoftwareOnlyUser();
        this.removeAllBrowsePermissions();
        this.navigation.login(SOFTWARE_ONLY_USER);
        this.assertIssueAccessDenied(this.issueKey);
        this.navigation.login("admin");
        this.grantBrowseAccessToApplicationRole("jira-software");
        this.navigation.login(SOFTWARE_ONLY_USER);
        this.assertIssueCanBeAccessed(this.issueKey);
        this.navigation.login(CORE_ONLY_USER);
        this.assertIssueAccessDenied(this.issueKey);
    }

    @Test
    public void testIssueSecurityLevelWithAnyProjectRoleGrantsAccessToAnyLoggedInUser() {
        this.grantBrowseAccessToAnonymous();
        this.navigation.logout();
        this.assertIssueCanBeAccessed(this.issueKey);
        this.createAndSetIssueLevelSecurityWithAppliationRole("");
        this.assertIssueCanBeAccessed(this.issueKey);
        this.navigation.logout();
        this.assertIssueAccessDenied(this.issueKey);
    }

    @Test
    public void testIssueSecurityLevelWithSpecificProjectRoleGrantsAccessToRoleMembers() {
        this.setupSoftwareOnlyUser();
        this.navigation.login(CORE_ONLY_USER);
        this.assertIssueCanBeAccessed(this.issueKey);
        this.navigation.login("admin");
        this.grantBrowseAccessToApplicationRole("");
        this.createAndSetIssueLevelSecurityWithAppliationRole("jira-software");
        this.navigation.login(CORE_ONLY_USER);
        this.assertIssueAccessDenied(this.issueKey);
        this.navigation.login(SOFTWARE_ONLY_USER);
        this.assertIssueCanBeAccessed(this.issueKey);
    }

    private void createAndSetIssueLevelSecurityWithAppliationRole(String applicationRoleValue) {
        this.navigation.login("admin");
        this.administration.issueSecuritySchemes().newScheme("Application Role Scheme", "").newLevel("Application Role Level", "").addIssueSecurity(IssueSecurityLevel.IssueSecurity.APPLICATION_ROLE, applicationRoleValue);
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "Application Role Scheme");
        String ISSUE_SECURITY_LEVEL_ID_JUST_CREATED = "10000";
        IssueFields issueFields = new IssueFields();
        issueFields.securityLevel(ResourceRef.withId((String)"10000"));
        this.backdoor.issues().setIssueFields(this.issueKey, issueFields);
    }

    private void setupSoftwareOnlyUser() {
        this.backdoor.applicationRoles().putRoleWithDefaultsSelectedByDefault("jira-software", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.backdoor.usersAndGroups().addUser(SOFTWARE_ONLY_USER);
        this.backdoor.usersAndGroups().addUserToGroup(SOFTWARE_ONLY_USER, "jira-developers");
    }

    private void grantBrowseAccessToAnonymous() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
    }

    private void grantBrowseAccessToApplicationRole(String roleFormValue) {
        this.backdoor.permissionSchemes().addApplicationRolePermission(0L, ProjectPermissions.BROWSE_PROJECTS, roleFormValue);
    }

    private void removeAllBrowsePermissions() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
    }

    private void assertIssueAccessDenied(String issueKey) {
        String actualIssueId = this.navigation.issue().viewIssue(issueKey).getIssueId();
        Assert.assertEquals((Object)"", (Object)actualIssueId);
    }

    private void assertIssueCanBeAccessed(String issueKey) {
        String actualIssueId = this.navigation.issue().viewIssue(issueKey).getIssueId();
        Assert.assertEquals((Object)this.issueId, (Object)actualIssueId);
    }
}

