/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestEventTypes
extends BaseJiraFuncTest {
    private final String CUSTOM_EVENT_TYPE_NAME = "Custom Event Type Name";
    private final String CUSTOM_EVENT_TYPE_DESC = "Custom Event Type Description";
    private final String EVENT_TYPE_TABLE = "eventTypeTable";
    private final int EVENT_TYPE_TABLE_NAME_COL = 0;
    private final String CREATE_EVENT_TYPE_NAME = "Issue Created";
    private final String COMMENT_EVENT_TYPE_NAME = "Issue Commented";
    private final String COMMENT_EDITED_EVENT_TYPE_NAME = "Issue Comment Edited";
    private final String REOPENED_EVENT_TYPE_NAME = "Issue Reopened";
    private final String WORKLOG_UPDATED_EVENT_TYPE_NAME = "Issue Worklog Updated";
    private final String WORKLOG_DELETED_EVENT_TYPE_NAME = "Issue Worklog Deleted";
    private final String GENERIC_EVENT_TYPE_NAME = "Generic Event";
    private final String[] eventOrder = new String[]{"Issue Created", "Issue Commented", "Issue Comment Edited", "Issue Reopened", "Issue Worklog Updated", "Issue Worklog Deleted", "Generic Event", "Custom Event Type Name"};
    private final String GENERIC_EVENT_TEMPLATE = "Generic Event";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testAddEventType() {
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
    }

    @Test
    public void testAddEventTypeWithErrors() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.setFormElement("name", "");
        this.tester.submit("Add");
        this.tester.assertTextPresent("You must specify an event name");
        this.tester.assertTextPresent("You must select a default template to associate with this event");
        this.tester.setFormElement("name", "Issue Created");
        this.tester.submit("Add");
        this.tester.assertTextPresent("An event with this name already exists");
        this.tester.assertTextPresent("You must select a default template to associate with this event");
    }

    @Test
    public void testDeleteEventType() {
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.deleteEventType("Custom Event Type Name");
        this.tester.assertTextNotPresent("Custom Event Type Name");
    }

    @Test
    public void testEditEventType() {
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.clickLink("edit_Custom Event Type Name");
        this.tester.assertTextPresent("Update");
        String NEW_NAME = "Custom Event Type New Name";
        String NEW_DESC = "Custom Event Type New Description";
        String NEW_TEMPLATE = "Issue Created";
        this.tester.setFormElement("name", "Custom Event Type New Name");
        this.tester.setFormElement("description", "Custom Event Type New Description");
        this.tester.selectOption("templateId", "Issue Created");
        this.tester.submit("Update");
        this.checkEventTypeDetails("Custom Event Type New Name", "Custom Event Type New Description", "Inactive", "Issue Created", null, null);
    }

    @Test
    public void testCreateNotificationAssociation() {
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        String eventTypeId = this.getEventTypeIDWithName("Custom Event Type Name");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.clickLink("add_" + eventTypeId);
        this.tester.checkCheckbox("type", "Current_Assignee");
        this.tester.submit("Add");
        this.checkNotificationForEvent("Custom Event Type Name", "Current Assignee", "Generic Event");
        this.checkEventTypeDetails("Custom Event Type Name", "Custom Event Type Description", "Active", "Generic Event", "Default Notification Scheme", null);
    }

    @Test
    public void testEventDefsOrder() {
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), this.eventOrder);
    }

    @Test
    public void testNotificationsEventOrder() {
        this.addEventType("Custom Event Type Name", "Custom Event Type Description", "Generic Event");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), this.eventOrder);
        this.tester.clickLink("add_1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), this.eventOrder);
    }

    @Test
    public void testEventWithApostropheDisplaysCorrectly() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.setFormElement("name", "This event isn't named nicely");
        this.tester.selectOption("templateId", "Generic Event");
        this.tester.submit("Add");
        this.tester.assertTextPresent("This event isn&#39;t named nicely");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("This event isn&#39;t named nicely");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira").textView().goTo();
        this.tester.clickLink("add_trans_3");
        this.tester.setFormElement("transitionName", "Test transition");
        this.tester.setFormElement("description", "");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Test transition");
        this.tester.clickLinkWithText("Post Functions");
        this.tester.clickLinkWithText("Edit", 1);
        this.tester.selectOption("eventTypeId", "This event isn't named nicely");
        this.tester.submit("Update");
        this.tester.assertTextPresent("This event isn&#39;t named nicely");
    }

    private void addEventType(String name, String description, String template) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.selectOption("templateId", template);
        this.tester.submit("Add");
        this.checkEventTypeDetails(name, description, "Inactive", template, null, null);
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID("eventTypeTable");
            String eventTypeCellText = fieldTable.getCellAsText(fieldTable.getRowCount() - 1, 0);
            Assert.assertTrue((boolean)eventTypeCellText.contains(name));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void deleteEventType(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.clickLink("del_" + name);
        this.tester.assertTextPresent("Please confirm that you wish to delete the event: <b>" + name + "</b>.");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent(name);
    }

    public String getEventTypeIDWithName(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        this.tester.clickLink("edit_" + name);
        return this.tester.getDialog().getFormParameterValue("eventTypeId");
    }

    public void checkEventTypeDetails(String eventTypeName, String eventTypeDesc, String status, String template, String notificationScheme, String workflow) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID("eventTypeTable");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains(eventTypeName)) continue;
                int EVENT_TYPE_TABLE_DESC_COL = 1;
                String eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_DESC_COL);
                Assert.assertTrue((boolean)eventTypeCellText.contains(eventTypeDesc));
                int EVENT_TYPE_TABLE_STATUS_COL = 2;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_STATUS_COL);
                Assert.assertTrue((boolean)eventTypeCellText.contains(status));
                int EVENT_TYPE_TABLE_TEMPLATE_COL = 3;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_TEMPLATE_COL);
                Assert.assertTrue((boolean)eventTypeCellText.contains(template));
                if (notificationScheme != null && !notificationScheme.equals("")) {
                    int EVENT_TYPE_TABLE_NOTIFIC_COL = 4;
                    eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_NOTIFIC_COL);
                    Assert.assertTrue((boolean)eventTypeCellText.contains(notificationScheme));
                }
                if (workflow == null || workflow.equals("")) continue;
                int EVENT_TYPE_TABLE_WORKFLOW_COL = 5;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_WORKFLOW_COL);
                Assert.assertTrue((boolean)eventTypeCellText.contains(workflow));
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void checkNotificationForEvent(String eventTypeName, String notificationType, String template) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        try {
            String NOTIFICATION_SCHEME_TABLE = "notificationSchemeTable";
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID("notificationSchemeTable");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                int NOTIFICATION_TABLE_NAME_COL = 0;
                String field = fieldTable.getCellAsText(i, NOTIFICATION_TABLE_NAME_COL);
                if (!field.contains(eventTypeName)) continue;
                int NOTIFICATION_TABLE_TYPE_COL = 1;
                TableCell notificationCell = fieldTable.getTableCell(i, NOTIFICATION_TABLE_TYPE_COL);
                if (notificationType == null) {
                    Assert.assertTrue((!notificationCell.asText().contains(notificationType) ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((boolean)notificationCell.asText().contains(notificationType));
            }
            this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

