/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.USERS_AND_GROUPS})
public class TestGroupBrowser
extends BaseJiraFuncTest {
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.navigation.login("admin");
    }

    @Test
    public void testGroupPagingWorks() {
        this.addSomeGroups();
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(40, 49);
        this.assertPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
    }

    @Test
    public void testGroupFilteringPagingWorks() {
        this.addSomeGroups();
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.setFilter("03");
        this.assertGroupNamesIsPresent(3, 3);
        this.assertGroupNamesIsPresent(30, 39);
        this.assertNextAndPrevNotPresent();
        this.setFilter("group");
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickNext();
        this.assertGroupNamesIsPresent(40, 49);
        this.assertPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(20, 39);
        this.assertNextAndPrevOnlyIsPresent();
        this.clickPrevious();
        this.assertGroupNamesIsPresent(0, 19);
        this.assertNextOnlyIsPresent();
    }

    @Test
    public void testApplicationAccessLozenges() {
        this.backdoor.license().set(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        this.backdoor.usersAndGroups().addGroup("jira-core-users");
        this.backdoor.usersAndGroups().addGroup("jira-test-users");
        this.backdoor.usersAndGroups().addGroup("multi-app-access");
        this.backdoor.applicationRoles().putRole("jira-core", "jira-core-users", "jira-administrators", "multi-app-access");
        this.backdoor.applicationRoles().putRole("jira-func-test", "jira-test-users", "multi-app-access");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.assertGroupLabels("jira-administrators", "Admin");
        this.assertGroupLabels("jira-core-users", "Jira Core");
        this.assertGroupLabels("jira-test-users", "Test Product");
        this.assertGroupLabels("multi-app-access", "Multi-App-Access");
    }

    private void assertGroupLabels(String groupName, String ... labels) {
        String rowXPath = String.format("//table[@id='group_browser_table']//a[text()='%s']/../..", groupName);
        this.textAssertions.assertTextSequence(new XPathLocator(this.tester, rowXPath), groupName, labels);
    }

    private void setFilter(String filterStr) {
        this.tester.setFormElement("nameFilter", filterStr);
        this.tester.submit("filter");
    }

    private void assertPrevOnlyIsPresent() {
        this.tester.assertTextNotPresent("Next");
        this.tester.assertTextPresent("Previous");
    }

    private void assertNextAndPrevOnlyIsPresent() {
        this.tester.assertTextPresent("Next");
        this.tester.assertTextPresent("Previous");
    }

    private void assertNextAndPrevNotPresent() {
        this.tester.assertTextNotPresent("Next");
        this.tester.assertTextNotPresent("Previous");
    }

    private void assertNextOnlyIsPresent() {
        this.tester.assertTextPresent("Next");
        this.tester.assertTextNotPresent("Previous");
    }

    private void clickNext() {
        this.tester.clickLinkWithText("Next >>");
    }

    private void clickPrevious() {
        this.tester.clickLinkWithText("Previous");
    }

    private void assertGroupNamesIsPresent(int start, int end) {
        ArrayList<String> listOfGroupNames = new ArrayList<String>();
        for (int i = start; i <= end; ++i) {
            listOfGroupNames.add(this.makeGroupName("group", i));
        }
        String[] groupNames = listOfGroupNames.toArray(new String[listOfGroupNames.size()]);
        this.textAssertions.assertTextSequence(new XPathLocator(this.tester, "//table[@id='group_browser_table']"), groupNames);
    }

    private void addSomeGroups() {
        for (int i = 0; i < 50; ++i) {
            this.backdoor.usersAndGroups().addGroup(this.makeGroupName("group", i));
        }
    }

    private String makeGroupName(String userName, int i) {
        return userName + new DecimalFormat("000").format(i);
    }

    @Test
    public void testAddBlankGroup() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", "");
        this.tester.submit("add_group");
        this.tester.assertTextPresent("You must specify valid group name.");
    }

    @Test
    public void testAddGroup() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", "my-test-group");
        this.tester.submit("add_group");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "group_browser_table"), "my-test-group");
    }
}

