/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.ProgressPageControl;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestIntegrityChecker
extends BaseJiraFuncTest {
    public static final String CHECK = "check";
    public static final String FIX = "fix";
    public static final String BACK = "back";
    public static final String ACKNOWLEDGE = "acknowledge";
    public static final String REFRESH = "refresh";
    private static final String INTEGRITY_CHECKBOX_TEXT_LOCATOR = "//table[@class='jiraform maxWidth']//td";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("integritycheckererror.xml");
    }

    @Test
    public void testAllIntegrityChecksPresent() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
        this.tester.assertTextPresent("Select one or more integrity checks from the list below to check for out of date information in the database.");
        this.assertIntegrityOptionDescriptionPresent("Select All");
        this.assertIntegrityOptionDescriptionPresent("Check Issue Relations");
        this.assertIntegrityOptionDescriptionPresent("Check Issue for Relation 'ParentProject'");
        this.assertIntegrityOptionDescriptionPresent("Check Issue for Relation 'RelatedOSWorkflowEntry'");
        this.assertIntegrityOptionDescriptionPresent("Check that all Issue Links are associated with valid issues");
        this.assertIntegrityOptionDescriptionPresent("Check Search Request");
        this.assertIntegrityOptionDescriptionPresent("Check search request references a valid project");
        this.assertIntegrityOptionDescriptionPresent("Check for Duplicate Permissions");
        this.assertIntegrityOptionDescriptionPresent("Check the permissions are not duplicated");
        this.assertIntegrityOptionDescriptionPresent("Check Workflow Integrity");
        this.assertIntegrityOptionDescriptionPresent("Check workflow entry states are correct");
        this.assertIntegrityOptionDescriptionPresent("Check workflow current step entries");
        this.assertIntegrityOptionDescriptionPresent("Check Jira issues with null status");
        this.assertIntegrityOptionDescriptionPresent("Check Field Layout Scheme Integrity");
        this.assertIntegrityOptionDescriptionPresent("Check field layout schemes for references to deleted custom fields");
        this.assertIntegrityOptionDescriptionPresent("Check for invalid filter subscriptions");
        this.assertIntegrityOptionDescriptionPresent("Check FilterSubscriptions for references to non-existent scheduled job");
        this.assertIntegrityOptionDescriptionPresent("Check FilterSubscriptions for references to non-existent SearchRequests");
    }

    @Test
    public void testIfTheCheckingAndFixingFlowIsNotBrokenAndTheProperMessagesAreDisplayed() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
        this.tester.checkCheckbox("integrity_check_1_1", "1");
        this.tester.checkCheckbox("integrity_check_1_2", "2");
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.checkCheckbox("integrity_check_2_4", "4");
        this.tester.checkCheckbox("integrity_check_3_5", "5");
        this.tester.submit(CHECK);
        this.tester.assertTextPresent("Checking the integrity for 5 checks.");
        this.tester.assertTextPresent("Integrity Checker operation is");
        ProgressPageControl.waitAndReload(this.tester, "integrity-checker-form", REFRESH, ACKNOWLEDGE);
        this.tester.assertTextPresent("Choose the errors you would like to fix, or return to the previous screen.");
        this.tester.assertTextPresent("ERROR");
        this.tester.submit(FIX);
        this.tester.assertTextPresent("Fixing the integrity for 1 check.");
        ProgressPageControl.waitAndReload(this.tester, "integrity-checker-form", REFRESH, ACKNOWLEDGE);
        this.tester.assertTextPresent("4 error(s) were corrected.");
        this.tester.assertTextPresent("FIXED");
        this.tester.submit(BACK);
        this.tester.assertTextPresent("Select one or more integrity checks from the list below to check for out of date information in the database.");
        this.tester.checkCheckbox("integrity_check_3_5", "5");
        this.tester.submit(CHECK);
        this.tester.assertTextPresent("Checking the integrity for 1 check.");
        ProgressPageControl.waitAndReload(this.tester, "integrity-checker-form", REFRESH, ACKNOWLEDGE);
        this.tester.assertTextPresent("No errors were found.");
        this.tester.submit(BACK);
        this.tester.assertTextPresent("Select one or more integrity checks from the list below to check for out of date information in the database.");
    }

    private void assertIntegrityOptionDescriptionPresent(String actual) {
        this.assertions.assertNodeHasText(INTEGRITY_CHECKBOX_TEXT_LOCATOR, actual);
    }
}

