/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Project;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.PERMISSIONS, Category.SCHEMES})
@LoginAs(user="admin")
public class TestOldPermissionSchemes
extends BaseJiraFuncTest {
    private static final String PERMISSION_SCHEMES_SINGLE_PAGE_DISABLED = "com.atlassian.jira.permission-schemes.single-page-ui.disabled";
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private GeneralConfiguration generalConfiguration;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;

    @Test
    @Restore(value="TestSchemesProjectRoles.xml")
    public void testProjectRolePermissionScheme() {
        this.logger.log((Object)"Test to check that project role permission scheme works");
        this.backdoor.darkFeatures().enableForSite(PERMISSION_SCHEMES_SINGLE_PAGE_DISABLED);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.tester.clickLink("add_perm_" + ProjectPermissions.MOVE_ISSUES.permissionKey());
        this.tester.assertTextPresent("Choose a project role");
        this.tester.checkCheckbox("type", "projectrole");
        this.tester.selectOption("projectrole", "test role");
        this.tester.submit();
        this.tester.assertTextPresent("(test role)");
    }

    public void permissionSchemesCreateScheme() {
        this.logger.log((Object)"Permission Schemes: Create a new permission scheme");
        this.createPermissionScheme("New Permission Scheme", "permission scheme for testing");
        this.tester.assertLinkPresentWithText("New Permission Scheme");
        this.tester.assertTextPresent("permission scheme for testing");
    }

    public void permissionSchemeDeleteScheme() {
        this.logger.log((Object)"Permission Schemes:Delete a permission scheme");
        this.deletePermissionScheme("New Permission Scheme");
        this.tester.assertLinkNotPresentWithText("New Permission Scheme");
    }

    public void permissionSchemeAssociateScheme() {
        this.logger.log((Object)"Permission Schemes: Associate a permission scheme with a project");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        Assert.assertThat((Object)this.backdoor.project().getSchemes((String)"NDT").permissionScheme.name, (Matcher)CoreMatchers.equalTo((Object)"New Permission Scheme"));
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemeAddDuplicateScheme() {
        this.logger.log((Object)"Permission Schemes: Attempt to create a scheme with a duplicate name");
        this.createPermissionScheme("New Permission Scheme", "");
        this.tester.assertTextPresent("Add permission scheme");
        this.tester.assertTextPresent("A Scheme with this name already exists.");
    }

    public void permissionSchemeAddInvalidScheme() {
        this.logger.log((Object)"Permission Schemes: Attempt to create a scheme with an invalid name");
        this.createPermissionScheme("", "");
        this.tester.assertTextPresent("Add permission scheme");
        this.tester.assertTextPresent("Please specify a name for this Scheme.");
    }

    private void permissionSchemesMoveIssueToProjectWithAssignablePermission(String issueKey) {
        this.logger.log((Object)"Move Operation: Moving issue to a project with 'Assign Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.generalConfiguration.setAllowUnassignedIssues(true);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.generalConfiguration.setAllowUnassignedIssues(false);
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemesMoveIssueWithSchedulePermission(String issueKey) {
        this.logger.log((Object)"Move Operation: Moving issue to a project with 'Schedule Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        try {
            this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.editIssueFieldVisibility.setDueDateToRequried();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("&quot;Due Date&quot; field is required and you do not have permission to Schedule Issues for project &quot;neanderthal&quot;.");
        this.editIssueFieldVisibility.resetFields();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void permissionSchemesMoveIssueToProjectWithCreatePermission(String issueKey) {
        this.logger.log((Object)"Move Operation: Moving issue to a project with 'Create Issue' Permission.");
        this.associatePermSchemeToProject("neanderthal", "New Permission Scheme");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(10000L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "neanderthal", "homosapien", "monkey", "neanderthal"});
        this.backdoor.permissionSchemes().removeGroupPermission(10000L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "homosapien", "monkey"});
        this.associatePermSchemeToProject("neanderthal", "Default Permission Scheme");
    }

    public void createPermissionScheme(String permission_name, String permission_desc) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Add Permission Scheme");
        this.tester.setFormElement("name", permission_name);
        this.tester.setFormElement("description", permission_desc);
        this.tester.submit("Add");
    }

    public void deletePermissionScheme(String permission_name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("del_" + permission_name);
        this.tester.submit("Delete");
    }

    public void associatePermSchemeToProject(String project, String permission_name) {
        String projectId = this.backdoor.project().getProjects().stream().filter((Predicate<Project>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$associatePermSchemeToProject$0(java.lang.String com.atlassian.jira.testkit.client.restclient.Project ), (Lcom/atlassian/jira/testkit/client/restclient/Project;)Z)((String)project)).findFirst().orElseThrow((Supplier<AssertionError>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/AssertionError;)()).id;
        this.navigation.gotoPage("/secure/project/SelectProjectPermissionScheme!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeIds", permission_name);
        this.tester.submit("Associate");
    }

    private static /* synthetic */ boolean lambda$associatePermSchemeToProject$0(String project, Project p) {
        return project.equals(p.name);
    }
}

