/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.SlowTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestSiteDarkFeatures
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testAdminUI() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoPage("/secure/admin/SiteDarkFeatures!default.jspa");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "site-disabled-features"), "jira.site.darkfeature.admin");
        this.backdoor.darkFeatures().enableForSite("jira.site.darkfeature.admin");
        this.navigation.gotoPage("/secure/admin/SiteDarkFeatures!default.jspa");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "site-disabled-features"), "jira.site.darkfeature.admin");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "site-enabled-features"), "jira.site.darkfeature.admin");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.gotoPage("/secure/admin/SiteDarkFeatures!default.jspa");
        this.textAssertions.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.textAssertions.assertTextNotPresent("System Property Dark Features");
    }

    @Test
    @SlowTest
    public void testAddSiteFeature() {
        this.administration.restoreDataSlowOldWay("blankprojects.xml");
        this.navigation.gotoPage("/secure/admin/SiteDarkFeatures!default.jspa");
        this.backdoor.darkFeatures().enableForSite("jira.site.feature.new");
        this.navigation.gotoPage("/secure/admin/SiteDarkFeatures!default.jspa");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "site-enabled-features"), "jira.site.feature.new");
    }
}

