/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestSystemInfoPage
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private EnvironmentUtils environmentUtils;

    @After
    public void tearDownTest() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
    }

    @Test
    public void testInstallationType() {
        String installationType = this.getEnvironmentData().getReleaseInfo();
        Assert.assertFalse((String)"You must have the 'jira.release.info' property set in your localtest.properties", (boolean)StringUtils.isBlank((CharSequence)installationType));
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Installation Type", installationType});
    }

    @Test
    public void testSupportRequestContainsMemoryAndInputArgsInfo() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        if (!this.isSunJVM()) {
            if (this.isJvmWithPermGen()) {
                this.tester.assertTextNotPresent("PermGen Memory Graph");
            }
            this.tester.assertTextNotPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        } else {
            this.tester.assertTextPresent("JVM Input Arguments");
            if (this.isJvmWithPermGen()) {
                this.tester.assertTextPresent("Used PermGen Memory");
                this.tester.assertTextPresent("Free PermGen Memory");
                this.tester.assertTextPresent("PermGen Memory Graph");
            }
            this.tester.assertTextNotPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        }
    }

    @Test
    public void testSystemInfoContainsTimezoneInfo() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("system_info_table");
        String systemTime = table.getCellAsText(2, 1).trim();
        Assert.assertTrue((String)("System time does not contain GMT offset '" + systemTime + "'"), (boolean)systemTime.matches(".*[-+]\\d{4}"));
        String timezoneLabel = table.getCellAsText(12, 0);
        Assert.assertEquals((Object)"User Timezone", (Object)timezoneLabel.trim());
        String timezoneValue = table.getCellAsText(12, 1);
        Assert.assertTrue((String)("Timezone value not present in text '" + timezoneValue + "'"), (timezoneValue.trim().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testApplicationPropertiesPresent() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTextInTable("application_properties", "jira.baseurl");
        this.tester.assertTextInTable("application_properties", "jira.option.voting");
        this.tester.assertTextInTable("application_properties", "jira.option.watching");
        this.tester.assertTextNotInTable("application_properties", "License Hash 1");
        this.tester.assertTextNotInTable("application_properties", "License Hash 1 Text");
        this.tester.assertTextNotInTable("application_properties", "License Message");
        this.tester.assertTextNotInTable("application_properties", "License Message Text");
        this.tester.assertTextNotInTable("application_properties", "License20");
        this.tester.assertTextNotInTable("application_properties", "jira.sid.key");
        this.tester.assertTextNotInTable("application_properties", "org.apache.shindig.common.crypto.BlobCrypter:key");
    }

    @Test
    public void testSystemInfoContainsJiraHome() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.assertTextInTable("file_paths", "Location of Jira Local Home");
    }

    @Test
    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        int lastRow = this.page.getHtmlTable("jirainfo").getRowCount() - 1;
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow, 1), "Deutsch (Deutschland)");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow - 1, 1), "Deutsch (Deutschland)");
    }

    @Test
    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        int lastRow = this.page.getHtmlTable("jirainfo").getRowCount() - 1;
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow, 1), "alem\u00e1n (Alemania)");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "jirainfo", lastRow - 1, 1), "espa\u00f1ol (Espa\u00f1a)");
    }

    @Test
    public void testGarbageCollectionLinkReturnsToSystemInfo() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.tester.clickLink("forceGarbageCollectionLink");
        this.assertions.assertNodeByIdExists("forceGarbageCollectionLink");
    }

    private boolean isJvmWithPermGen() {
        return this.environmentUtils.isJvmWithPermGen();
    }

    private boolean isSunJVM() {
        return this.environmentUtils.isSunJVM();
    }
}

