/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.allowlisthost;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@RestoreBlankInstance
public class TestAdminAllowlistHosts
extends BaseJiraFuncTest {
    public static final String ALLOW_LIST = "ALLOW_LIST";
    public static final String BASEURL = "BASEURL";
    public static final String HOST_FROM_REQUEST = "HOST_FROM_REQUEST";
    private static final String NOT_SYS_ADMIN_USERNAME = "notsysadmin";
    private static final String NOT_SYS_ADMIN_GROUP = "notsysadmins_group";
    private static final String SELF_FIELD_CREATION_TYPE = "Self field creation type";
    private static final String UPDATE = "Update";
    private static final String SELF_URL_ORIGIN_TYPE = "selfUrlOriginType";

    @Before
    public void setUp() {
        this.backdoor.getTestkit().usersAndGroups().addGroup(NOT_SYS_ADMIN_GROUP);
        this.backdoor.getTestkit().usersAndGroups().addUser(NOT_SYS_ADMIN_USERNAME);
        this.backdoor.getTestkit().usersAndGroups().addUserToGroup(NOT_SYS_ADMIN_USERNAME, NOT_SYS_ADMIN_GROUP);
        this.backdoor.getTestkit().permissions().addGlobalPermission(0, NOT_SYS_ADMIN_GROUP);
        this.backdoor.getTestkit().auditing().clearAllRecords();
    }

    @Test
    @LoginAs(user="admin")
    public void testJiraSystemAdminIsAbleToSelectSelfCreationTypeAsAllowHost() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION_EDIT);
        this.tester.assertTextPresent(SELF_FIELD_CREATION_TYPE);
        this.tester.setFormElement(SELF_URL_ORIGIN_TYPE, ALLOW_LIST);
        this.tester.submit(UPDATE);
        this.tester.assertTextNotPresent(SELF_FIELD_CREATION_TYPE);
    }

    @Test
    @LoginAs(user="admin")
    public void testJiraSystemAdminIsAbleToSelectSelfCreationTypeAsBaseUrl() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION_EDIT);
        this.tester.assertTextPresent(SELF_FIELD_CREATION_TYPE);
        this.tester.setFormElement(SELF_URL_ORIGIN_TYPE, BASEURL);
        this.tester.submit(UPDATE);
        this.tester.assertTextNotPresent(SELF_FIELD_CREATION_TYPE);
    }

    @Test
    @LoginAs(user="admin")
    public void testJiraSystemAdminIsAbleToSelectSelfCreationTypeAsExisting() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION_EDIT);
        this.tester.assertTextPresent(SELF_FIELD_CREATION_TYPE);
        this.tester.setFormElement(SELF_URL_ORIGIN_TYPE, HOST_FROM_REQUEST);
        this.tester.submit(UPDATE);
        this.tester.assertTextNotPresent(SELF_FIELD_CREATION_TYPE);
    }

    @Test
    public void testJiraAdminIsNotAbleToSeeAllowListHostFields() {
        this.navigation.login(NOT_SYS_ADMIN_USERNAME);
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION_EDIT);
        this.tester.assertTextNotPresent(SELF_FIELD_CREATION_TYPE);
    }
}

