/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.allowlisthost;

import com.atlassian.jira.webtests.ztests.admin.allowlisthost.TestProjectForSelfField;
import com.atlassian.jira.webtests.ztests.admin.allowlisthost.WhitelistRequest;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;

public final class WhitelistRestCallHelper {
    private WhitelistRestCallHelper() {
        throw new IllegalStateException("Utility class");
    }

    static void addNewWhitelistItem(String baseUrl, String host) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String json = new GsonBuilder().create().toJson((Object)new WhitelistRequest("whitelist.wildcard.expression", TestProjectForSelfField.createTemporaryBaseUrl(host, baseUrl), false, false));
            HttpPost postRequest = new HttpPost(baseUrl + "/rest/whitelist/latest/");
            postRequest.setEntity((HttpEntity)new StringEntity(json));
            String credentials = String.format("%s:%s", "admin", "admin");
            String encodedAuth = new String(Base64.encodeBase64((byte[])credentials.getBytes(StandardCharsets.ISO_8859_1)));
            String authHeader = "Basic " + encodedAuth;
            postRequest.addHeader("Authorization", authHeader);
            postRequest.addHeader("X-Atlassian-Token", "no-check");
            postRequest.setHeader("Content-type", "application/json");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);){
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            }
        }
    }
}

