/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.audit;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.rest.util.serializers.ISODateSerializer;
import com.atlassian.jira.webtests.ztests.admin.audit.TestingAuditRecord;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class MockAuditRecordBean {
    private Long id;
    private String summary;
    private String remoteAddress;
    private String authorKey;
    private DateTime created;
    private String category;
    private String eventSource;
    private String description;
    private AssociatedItemBean objectItem;
    private List<ChangedValueBean> changedValues;
    private List<AssociatedItemBean> associatedItems;

    public MockAuditRecordBean() {
    }

    public MockAuditRecordBean(TestingAuditRecord auditRecord, String categoryName) {
        this(auditRecord, categoryName, null, null, null);
    }

    public MockAuditRecordBean(TestingAuditRecord auditRecord, String categoryName, Long projectId) {
        this(auditRecord, categoryName, projectId, null, null);
    }

    public MockAuditRecordBean(TestingAuditRecord auditRecord, String categoryName, Long projectId, String affectedObjectUsersId) {
        this(auditRecord, categoryName, projectId, affectedObjectUsersId, null);
    }

    public MockAuditRecordBean(TestingAuditRecord auditRecord, String categoryName, Long projectId, String affectedObjectUserId, String associatedItemUserId) {
        this.id = auditRecord.getId();
        this.summary = auditRecord.getSummary();
        this.remoteAddress = auditRecord.getRemoteAddr();
        this.authorKey = auditRecord.getAuthorKey();
        this.created = new DateTime((Object)auditRecord.getCreated());
        this.category = categoryName;
        this.eventSource = auditRecord.getEventSource();
        this.description = auditRecord.getDescription();
        this.objectItem = affectedObjectUserId != null ? new AssociatedItemBean(affectedObjectUserId + "-name", affectedObjectUserId, AssociatedItem.Type.USER.toString()) : (auditRecord.getObjectItem() != null ? new AssociatedItemBean() : null);
        this.changedValues = ImmutableList.of();
        if (projectId != null || associatedItemUserId != null) {
            String projectName = "homosapience";
            this.associatedItems = new ArrayList<AssociatedItemBean>();
            if (projectId != null) {
                this.associatedItems.add(new AssociatedItemBean("homosapience", projectId.toString(), AssociatedItem.Type.PROJECT.toString()));
            }
            if (associatedItemUserId != null) {
                this.associatedItems.add(new AssociatedItemBean(associatedItemUserId + "-name", associatedItemUserId, AssociatedItem.Type.USER.toString()));
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getAuthorKey() {
        return this.authorKey;
    }

    @JsonSerialize(using=ISODateSerializer.class)
    public DateTime getCreated() {
        return this.created;
    }

    public AssociatedItemBean getObjectItem() {
        return this.objectItem;
    }

    public String getCategory() {
        return this.category;
    }

    public Iterable<AssociatedItemBean> getAssociatedItems() {
        return this.associatedItems;
    }

    public Iterable<ChangedValueBean> getChangedValues() {
        return this.changedValues;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class ChangedValueImpl
    implements ChangedValue {
        private final String name;
        private final String from;
        private final String to;

        public ChangedValueImpl(String name, String from, String to) {
            this.name = name;
            this.from = from;
            this.to = to;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getFrom() {
            return this.from;
        }

        @Nullable
        public String getTo() {
            return this.to;
        }
    }

    private class ChangedValueBean {
        private ChangedValueBean() {
        }
    }

    private class AssociatedItemBean {
        private final String name;
        private final String id;
        private final String typeName;

        public AssociatedItemBean() {
            this("jira-users", "jira-users", AssociatedItem.Type.GROUP.toString());
        }

        public AssociatedItemBean(String name, String id, String typeName) {
            this.name = name;
            this.id = id;
            this.typeName = typeName;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getParentName() {
            return "JIRA Internal Directory";
        }

        @Nullable
        public String getParentId() {
            return "1";
        }

        @Nonnull
        public String getTypeName() {
            return this.typeName;
        }
    }
}

