/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.audit;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.AdvancedAuditingClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestAuditCategoryMigration
extends BaseJiraFuncTest {
    private static final int MIGRATION_AUDIT_LOGS_COUNT = 660;
    private static final String CATEGORIES_MIGRATION_ACTION = "categories_migration";

    @Test
    @Restore(value="TestAuditEntityCategoriesMigration.zip")
    @SinceBuildRule.SinceBuild(buildNumber=815000)
    public void testAuditCategoryMigration() {
        this.backdoor.upgradeClient().runUpgrades(60);
        List<AdvancedAuditingClient.AuditEntities> events = this.getMigratedEventsOnly(this.backdoor.advancedAuditing().takeAllEvents(1000));
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)660));
        this.assertThatAuditCategoryMigratedProperly(events);
    }

    private void assertThatAuditCategoryMigratedProperly(List<AdvancedAuditingClient.AuditEntities> events) {
        events.forEach(event -> Assert.assertThat((Object)event.getType().getCategory(), (Matcher)Matchers.isOneOf((Object[])this.getExpectedCategories())));
    }

    private List<AdvancedAuditingClient.AuditEntities> getMigratedEventsOnly(List<AdvancedAuditingClient.AuditEntities> events) {
        return events.stream().filter(a -> CATEGORIES_MIGRATION_ACTION.equals(a.getType().getAction())).collect(Collectors.toList());
    }

    private String[] getExpectedCategories() {
        return new String[]{"auditing", "advanced auditing", "user management", "group management", "permissions", "workflows", "notifications", "fields", "projects", "system", "migration", "applications", "user data transfer", "sprints", "boards", "issue types", "issue", "configuration", "dashboards", "filters", "search", "mail settings", "user interface", "screens", "indexing", "login", "field config scheme", "clustering", "security", "ecosystem", "issue security level", "nomenclature"};
    }
}

