/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.audit;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.AdvancedAuditingClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.BeforeBuildRule;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.webtests.ztests.admin.AuditingClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class TestAuditMigration
extends BaseJiraFuncTest {
    private static final int MIGRATION_AUDIT_LOGS_COUNT = 74;
    private static final String BROWSER_METHOD = "Browser";
    private static final String SAMPLE_NAME = "Sample Name";
    private static final String SAMPLE_DESCRIPTION = "Sample Description";
    private static final String SAMPLE_LONG_DESCRIPTION = "Sample Long Description";

    @Test
    @Restore(value="TestAuditLogMigration.xml")
    @BeforeBuildRule.BeforeBuild(buildNumber=812000)
    public void testUpgradeTaskWithoutDescription() {
        this.testUpgradeTask(null);
    }

    @Test
    @Restore(value="TestAuditLogMigration.xml")
    @SinceBuildRule.SinceBuild(buildNumber=812000)
    public void testUpgradeTaskWithDescription() {
        this.testUpgradeTask(SAMPLE_DESCRIPTION);
    }

    @Test
    @Restore(value="TestAuditLogMigration.xml")
    @SinceBuildRule.SinceBuild(buildNumber=812000)
    public void testMigrateAttributesWithNamesTranslated() {
        this.backdoor.upgradeClient().runUpgrades(10);
        List<AdvancedAuditingClient.AuditEntities> events = this.getMigratedEventsOnly(this.backdoor.advancedAuditing().takeAllEvents());
        Assert.assertThat(events, (Matcher)Matchers.hasSize((int)74));
        this.assertThatAttributesMigratedWithNamesTranslated(events);
    }

    private void testUpgradeTask(String expectedDescription) {
        Long auditLogCountBefore = this.backdoor.entityEngine().countByAnd("AuditLog", new HashMap());
        Assert.assertThat((Object)auditLogCountBefore, (Matcher)Matchers.equalTo((Object)74L));
        this.backdoor.upgradeClient().runUpgrades(10);
        Long auditLogCountAfter = this.backdoor.entityEngine().countByAnd("AuditLog", new HashMap());
        Assert.assertThat((Object)auditLogCountAfter, (Matcher)Matchers.equalTo((Object)0L));
        AuditingClient.ViewResponse auditLogs = this.backdoor.auditing().getViewResponse();
        List<AuditingClient.ViewResponse.RecordResponse> auditLogsRecords = auditLogs.getRecords();
        Assert.assertThat(auditLogsRecords, this.matches("Global permission added", "20/Dec/19 1:39 PM", expectedDescription, this.associatedItemMatcher("Global Permissions", "PERMISSIONS", null), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Permission", "Create Shared Objects", ""), this.newChangedValue("Group", "jira-servicedesk-users", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("Global permission added", "20/Dec/19 1:39 PM", expectedDescription, this.associatedItemMatcher("Global Permissions", "PERMISSIONS", null), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Permission", "Create Shared Objects", ""), this.newChangedValue("Group", "jira-servicedesk-users", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("New license added", "20/Dec/19 1:39 PM", expectedDescription, this.associatedItemMatcher("2016178", "LICENSE", "0"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Organisation", "Atlassian", null), this.newChangedValue("Date Purchased", "31/Aug/14", null), this.newChangedValue("License Type", "JIRA Unlimited Users: Commercial License", null), this.newChangedValue("Server ID", "BZQK-F9EL-I0CG-KANJ", null), this.newChangedValue("Support Entitlement Number (SEN)", "2016178", null), this.newChangedValue("User Limit", "Unlimited", null), this.newChangedValue("jira-servicedesk", "-1", null), this.newChangedValue("jira-software", "-1", null), this.newChangedValue("jira-core", "-1", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("User created", "20/Dec/19 1:44 PM", expectedDescription, this.associatedItemMatcher("admin", "USER", "JIRAUSER10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Username", "admin", null), this.newChangedValue("Full name", "admin", null), this.newChangedValue("Email", "admin@admin", null), this.newChangedValue("Active / Inactive", "Active", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("User added to group", "20/Dec/19 1:44 PM", expectedDescription, this.associatedItemMatcher("jira-administrators", "GROUP", null), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("admin", "USER", "JIRAUSER10000")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.emptyIterable()));
        Assert.assertThat(auditLogsRecords, this.matches("Workflow created", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("TEST: Project Management Workflow", "WORKFLOW", "TEST: Project Management Workflow"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "TEST: Project Management Workflow", null), this.newChangedValue("Description", "", null), this.newChangedValue("Status", "To Do", null), this.newChangedValue("Status", "In Progress", null), this.newChangedValue("Status", "Done", null), this.newChangedValue("Transition", "Create (To Do)", null), this.newChangedValue("Transition", "Start Progress (To Do -> In Progress)", null), this.newChangedValue("Transition", "Done (To Do -> Done)", null), this.newChangedValue("Transition", "Stop Progress (In Progress -> To Do)", null), this.newChangedValue("Transition", "Done (In Progress -> Done)", null), this.newChangedValue("Transition", "Reopen (Done -> To Do)", null), this.newChangedValue("Transition", "Reopen and start progress (Done -> In Progress)", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Workflow scheme created", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("TEST: Project Management Workflow Scheme", "SCHEME", "10100"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "TEST: Project Management Workflow Scheme", null), this.newChangedValue("Description", "", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Workflow scheme added to project", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("test", "PROJECT", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("TEST: Project Management Workflow Scheme", "SCHEME", "10100")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.emptyIterable()));
        Assert.assertThat(auditLogsRecords, this.matches("Workflow updated", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("TEST: Project Management Workflow", "WORKFLOW", "TEST: Project Management Workflow"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.emptyIterable()));
        Assert.assertThat(auditLogsRecords, this.matches("Filter created", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("Open and unassigned (TEST)", "FILTER", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("admin", "USER", "JIRAUSER10000"), new AuditingClient.ViewResponse.AssociatedItemResponse("test", "PROJECT", "10000")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "Open and unassigned (TEST)", ""), this.newChangedValue("Description", null, ""), this.newChangedValue("Owner", "JIRAUSER10000", ""), this.newChangedValue("Shared With", "[Project: test (VIEW)]", "[]"), this.newChangedValue("JQL Query", "{project = 10000} AND {statusCategory != \"Done\"} AND {assignee = EMPTY} order by priority DESC", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("Project created", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("test", "PROJECT", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("admin", "USER", "JIRAUSER10000")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "test", null), this.newChangedValue("Key", "TEST", null), this.newChangedValue("Description", "<h3>Welcome to the administration of your demonstration project!</h3>\n <p>This is where you can view and change how the project is configured. Use the tabs on the left to navigate to different project settings.</p>", null), this.newChangedValue("Project Lead", "admin", null), this.newChangedValue("Default Assignee", "Unassigned", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Project roles changed", "20/Dec/19 1:50 PM", expectedDescription, this.associatedItemMatcher("Developers", "PROJECT_ROLE", "10100"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("test", "PROJECT", "10000")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Users", "JIRAUSER10000", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Issue type created", "20/Dec/19 1:54 PM", expectedDescription, this.associatedItemMatcher("new issue type", "ISSUE_TYPE", "10002"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.emptyIterable()));
        Assert.assertThat(auditLogsRecords, this.matches("Workflow scheme updated", "20/Dec/19 1:59 PM", expectedDescription, this.associatedItemMatcher("new wf scheme", "SCHEME", "10101"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.emptyIterable()));
        Assert.assertThat(auditLogsRecords, this.matches("A new field added to the screen's tab", "20/Dec/19 1:59 PM", expectedDescription, this.associatedItemMatcher("My screen", "SCREEN", "10003"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "Description", ""), this.newChangedValue("Field id", "description", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("Custom field created", "20/Dec/19 2:00 PM", expectedDescription, this.associatedItemMatcher("text cf", "CUSTOM_FIELD", "customfield_10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "text cf", null), this.newChangedValue("Type", "Text Field (single line)", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Field Configuration scheme created", "20/Dec/19 2:07 PM", expectedDescription, this.associatedItemMatcher("my field config scheme", "SCHEME", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "my field config scheme", null), this.newChangedValue("Description", "test desc", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Field Configuration scheme updated", "20/Dec/19 2:07 PM", expectedDescription, this.associatedItemMatcher("my field config scheme", "SCHEME", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Issue Type", "new issue type", ""), this.newChangedValue("Field Configuration", "new field config", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("Notification scheme created", "20/Dec/19 2:10 PM", expectedDescription, this.associatedItemMatcher("test notification scheme", "SCHEME", "10100"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "test notification scheme", null), this.newChangedValue("Description", "", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Notification scheme updated", "20/Dec/19 2:10 PM", expectedDescription, this.associatedItemMatcher("test notification scheme", "SCHEME", "10100"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Event", "Issue Created", ""), this.newChangedValue("Type", "Current User", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("Permission scheme created", "20/Dec/19 2:10 PM", expectedDescription, this.associatedItemMatcher("new permission scheme", "SCHEME", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "new permission scheme", null), this.newChangedValue("Description", "", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Permission scheme updated", "20/Dec/19 2:11 PM", expectedDescription, this.associatedItemMatcher("new permission scheme", "SCHEME", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Permission", "Administer Projects", ""), this.newChangedValue("Type", "Project Role", ""), this.newChangedValue("Value", "Administrators", "")})));
        Assert.assertThat(auditLogsRecords, this.matches("Project updated", "20/Dec/19 2:13 PM", expectedDescription, this.associatedItemMatcher("test project", "PROJECT", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "test project", "test"), this.newChangedValue("Description", "<h3>Welcome to the administration of your demonstration project!</h3>\n <p>This is where you can view and change how the project is configured. Use the tabs on the left to navigate to different project settings.</p>\nble", "<h3>Welcome to the administration of your demonstration project!</h3>\n <p>This is where you can view and change how the project is configured. Use the tabs on the left to navigate to different project settings.</p>"), this.newChangedValue("URL", "", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Project version created", "20/Dec/19 2:13 PM", expectedDescription, this.associatedItemMatcher("test version", "VERSION", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("test project", "PROJECT", "10000")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "test version", null), this.newChangedValue("Description", "", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Project component created", "20/Dec/19 2:13 PM", expectedDescription, this.associatedItemMatcher("test components", "PROJECT_COMPONENT", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("test project", "PROJECT", "10000")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Name", "test components", null), this.newChangedValue("Default Assignee", "Component Lead", null)})));
        Assert.assertThat(auditLogsRecords, this.matches("Project updated", "20/Dec/19 2:14 PM", expectedDescription, this.associatedItemMatcher("test project", "PROJECT", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.contains((Object[])new AuditingClient.ViewResponse.AssociatedItemResponse[]{new AuditingClient.ViewResponse.AssociatedItemResponse("test", "USER", "JIRAUSER10100")}), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.containsInAnyOrder((Object[])new AuditingClient.ViewResponse.ChangedValueResponse[]{this.newChangedValue("Project Lead", "test", "admin"), this.newChangedValue("Default Assignee", "Project Lead", "Unassigned")})));
        Assert.assertThat(auditLogsRecords, this.matches("Project avatar changed", "20/Dec/19 2:14 PM", expectedDescription, this.associatedItemMatcher("test project", "PROJECT", "10000"), (Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>>)Matchers.emptyIterable(), (Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>>)Matchers.emptyIterable()));
    }

    private void assertThatAttributesMigratedWithNamesTranslated(List<AdvancedAuditingClient.AuditEntities> events) {
        String eventSource = this.backdoor.i18n().getText("jira.auditing.extra.parameters.event.source.name", "en_UK");
        String description = this.backdoor.i18n().getText("jira.auditing.extra.parameters.event.description", "en_UK");
        String longDescription = this.backdoor.i18n().getText("jira.auditing.extra.parameters.event.long.description", "en_UK");
        events.forEach(event -> {
            Assert.assertThat((Object)this.getExtraAttribute((AdvancedAuditingClient.AuditEntities)event, eventSource), (Matcher)Matchers.is((Object)SAMPLE_NAME));
            Assert.assertThat((Object)this.getExtraAttribute((AdvancedAuditingClient.AuditEntities)event, description), (Matcher)Matchers.is((Object)SAMPLE_DESCRIPTION));
            Assert.assertThat((Object)this.getExtraAttribute((AdvancedAuditingClient.AuditEntities)event, longDescription), (Matcher)Matchers.is((Object)SAMPLE_LONG_DESCRIPTION));
        });
    }

    private String getExtraAttribute(AdvancedAuditingClient.AuditEntities event, String attributeName) {
        return this.getExtraAttributes(event).get(attributeName);
    }

    private Map<String, String> getExtraAttributes(AdvancedAuditingClient.AuditEntities event) {
        return event.getExtraAttributes().stream().collect(Collectors.toMap(AdvancedAuditingClient.AuditExtraAttributes::getName, AdvancedAuditingClient.AuditExtraAttributes::getValue));
    }

    private List<AdvancedAuditingClient.AuditEntities> getMigratedEventsOnly(List<AdvancedAuditingClient.AuditEntities> events) {
        return events.stream().filter(a -> !BROWSER_METHOD.equals(a.getMethod()) && StringUtils.isNotBlank((CharSequence)a.getSource())).collect(Collectors.toList());
    }

    private Matcher<AuditingClient.ViewResponse.AssociatedItemResponse> associatedItemMatcher(String name, String type, String id) {
        return Matchers.equalTo((Object)new AuditingClient.ViewResponse.AssociatedItemResponse(name, type, id));
    }

    private AuditingClient.ViewResponse.ChangedValueResponse newChangedValue(String name, String to, String from) {
        return new AuditingClient.ViewResponse.ChangedValueResponse(name, to, from);
    }

    private Matcher<Iterable<? super AuditingClient.ViewResponse.RecordResponse>> matches(String summary, String created, String description, Matcher<AuditingClient.ViewResponse.AssociatedItemResponse> objectItemMatcher, Matcher<Iterable<? extends AuditingClient.ViewResponse.AssociatedItemResponse>> associatedItemsMatcher, Matcher<Iterable<? extends AuditingClient.ViewResponse.ChangedValueResponse>> changedValuesMatcher) {
        return CoreMatchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"summary", (Matcher)Matchers.equalTo((Object)summary)), (Matcher)Matchers.hasProperty((String)"description", (Matcher)Matchers.equalTo((Object)description)), (Matcher)Matchers.hasProperty((String)"created", (Matcher)Matchers.equalTo((Object)created)), (Matcher)Matchers.hasProperty((String)"objectItem", objectItemMatcher), (Matcher)Matchers.hasProperty((String)"associatedItems", associatedItemsMatcher), (Matcher)Matchers.hasProperty((String)"changedValues", changedValuesMatcher)));
    }
}

