/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.index;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.IndexingControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING, Category.WORKLOGS})
@LoginAs(user="admin")
public class TestIndexingInBackground
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @After
    public void startRepairService() {
        this.backdoor.indexing().startIndexRepairService();
    }

    public void setUpWithBlankInstance() {
        this.backdoor.restoreBlankInstance();
        this.setupInstance();
    }

    public void setUpWithDataWithTestIndexCorrupted() {
        this.administration.restoreData("TestIndexingCorrupt.xml");
        this.setupInstance();
    }

    private void setupInstance() {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.applicationProperties().setOption("jira.default.timezone", true);
        this.backdoor.indexing().pauseIndexRepairService();
    }

    @Test
    public void testBackgroundReindexingSmokeTest() throws Exception {
        this.setUpWithBlankInstance();
        String summary = "first issue!";
        String reporter = "admin";
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        new BackgroundReindex().run().waitForCompletion();
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        SearchResult all = this.backdoor.search().getSearch(new SearchRequest());
        Assert.assertThat((Object)all.total, (Matcher)Matchers.equalTo((Object)1));
        Issue issue = (Issue)all.issues.get(0);
        Assert.assertThat((Object)issue.key, (Matcher)Matchers.equalTo((Object)testIssue.key()));
        Assert.assertThat((Object)issue.fields.summary, (Matcher)Matchers.equalTo((Object)"first issue!"));
        Assert.assertThat((Object)issue.fields.reporter.name, (Matcher)Matchers.equalTo((Object)"admin"));
    }

    @Test
    public void testEditingAnIssueDuringABackgroundReindexShouldNotCauseLostUpdates() throws Exception {
        this.setUpWithBlankInstance();
        final IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        BackgroundReindex reindex = new BackgroundReindex();
        reindex.runConcurrently(new Runnable(){

            @Override
            public void run() {
                TestIndexingInBackground.this.sleep(1100);
                TestIndexingInBackground.this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
                TestIndexingInBackground.this.backdoor.issues().assignIssue(testIssue.key(), "fred");
                SearchResult results = TestIndexingInBackground.this.backdoor.search().getSearch(new SearchRequest().jql("assignee = fred"));
                Assert.assertThat((String)"Single issue indexing during background reindex did not work", (Object)results.total, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((String)"Single issue indexing during background reindex did not work", (Object)((Issue)results.issues.get((int)0)).key, (Matcher)Matchers.equalTo((Object)testIssue.key()));
            }
        }).waitForCompletion();
        SearchResult results = this.backdoor.search().getSearch(new SearchRequest().jql("assignee = fred"));
        Assert.assertThat((Object)results.total, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"Detected lost update in index", (Object)((Issue)results.issues.get((int)0)).key, (Matcher)Matchers.equalTo((Object)testIssue.key()));
    }

    @Test
    public void testBackgroundReindexWillReindexIssueEvenIfPreviousIndexingOperationWasLost() throws Exception {
        this.setUpWithBlankInstance();
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.sleep(1100);
        this.backdoor.issueNavControl().touch(testIssue.key());
        Assert.assertThat((Object)this.backdoor.indexing().isIndexUpdatedFieldConsistent(), (Matcher)Matchers.equalTo((Object)false));
        this.backdoor.indexing().startInBackground().waitForCompletion();
        Assert.assertThat((Object)this.backdoor.indexing().isIndexUpdatedFieldConsistent(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testBackgroundReindexWithComments() throws Exception {
        this.setUpWithBlankInstance();
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        this.backdoor.issues().commentIssue(testIssue.key, "First searchable comment. Magic word is hamster");
        IssueCreateResponse testIssue2 = this.backdoor.issues().createIssue("HSP", "second issue!", "admin");
        this.backdoor.issues().commentIssue(testIssue2.key, "Second searchable comment. Magic word is Basil");
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deindex(testIssue.key);
        this.backdoor.indexing().deindex(testIssue2.key);
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ hamster"));
        Assert.assertEquals((long)0L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("reporter WAS admin"));
        Assert.assertEquals((long)0L, (long)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ISSUE_ONLY).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ hamster"));
        Assert.assertEquals((long)0L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("assignee WAS admin"));
        Assert.assertEquals((long)2L, (long)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ALL).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ hamster"));
        Assert.assertEquals((long)1L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ magic"));
        Assert.assertEquals((long)2L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("assignee WAS admin"));
        Assert.assertEquals((long)2L, (long)result.issues.size());
    }

    @Test
    public void testConfigChangeDuringIndexGetsNewMessage() throws Exception {
        this.setUpWithBlankInstance();
        this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        BackgroundReindex reindex = new BackgroundReindex();
        this.administration.generalConfiguration().disableVoting();
        this.administration.generalConfiguration().enableVoting();
        this.assertVotingMessage();
        reindex.runConcurrently(new Runnable(){

            @Override
            public void run() {
                TestIndexingInBackground.this.sleep(1100);
                TestIndexingInBackground.this.administration.generalConfiguration().disableVoting();
                TestIndexingInBackground.this.administration.generalConfiguration().enableVoting();
                TestIndexingInBackground.this.assertVotingMessage();
            }
        }).waitForCompletion();
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
    }

    @Test
    public void testBackgroundReindexWithWorklogs() throws Exception {
        this.setUpWithBlankInstance();
        IssueCreateResponse testIssue = this.backdoor.issues().createIssue("HSP", "first issue!", "admin");
        IssueCreateResponse testIssue2 = this.backdoor.issues().createIssue("HSP", "second issue!", "admin");
        WorklogClient worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        Worklog worklog = new Worklog();
        worklog.started = "2014-08-06T10:49:43.421+0200";
        worklog.timeSpent = "1h";
        worklogClient.post(testIssue.key, worklog);
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deindex(testIssue.key);
        this.backdoor.indexing().deindex(testIssue2.key);
        this.backdoor.indexing().indexDummyIssue(Long.valueOf(testIssue.id), 10000L, "1", testIssue.key, "first issue!", "first issue!");
        this.backdoor.indexing().indexDummyIssue(Long.valueOf(testIssue2.id), 10000L, "1", testIssue2.key, "second issue!", "second issue!");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogDate=2014-08-06"));
        Assert.assertEquals((long)0L, (long)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ISSUE_ONLY).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogDate=2014-08-06"));
        Assert.assertEquals((long)0L, (long)result.issues.size());
        new BackgroundReindex(IssueIndexingParams.INDEX_ALL).run().waitForCompletion();
        result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogDate=2014-08-06"));
        Assert.assertEquals((long)1L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("worklogAuthor=admin"));
        Assert.assertEquals((long)1L, (long)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("assignee WAS admin"));
        Assert.assertEquals((long)2L, (long)result.issues.size());
    }

    @Test
    public void testIssueIndexIsCorrupt() throws Exception {
        this.setUpWithDataWithTestIndexCorrupted();
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest());
        Assert.assertEquals((long)20L, (long)result.issues.size());
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
        try {
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)0L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            for (int i = 0; i < 20; ++i) {
                this.backdoor.issues().createIssue("HSP", "An issue which will be indexed " + i);
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)20L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    @Test
    public void testReindexWhenIssuesMissing() throws Exception {
        this.setUpWithDataWithTestIndexCorrupted();
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest());
        Assert.assertEquals((long)20L, (long)result.issues.size());
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
        try {
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)0L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            for (int i = 0; i < 20; ++i) {
                this.backdoor.issues().createIssue("HSP", "An issue which will be indexed " + i);
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)20L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            new BackgroundReindex(IssueIndexingParams.INDEX_ALL).run().waitForCompletion();
            Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    @Test
    public void testReindexWhenExtraIssues() throws Exception {
        this.setUpWithDataWithTestIndexCorrupted();
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest());
        Assert.assertEquals((long)20L, (long)result.issues.size());
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        try {
            for (int i = 0; i < 20; ++i) {
                this.backdoor.indexing().indexDummyIssue(1000 + i, 10000L, "1", "HSP-" + (1000 + i), "New issue summary " + i, "new issue description" + i);
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)40L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            new BackgroundReindex().run().waitForCompletion();
            Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)20L, (long)result.issues.size());
            Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    @Test
    public void testCommentIndexIsCorrupt() throws Exception {
        this.administration.restoreData("TestIndexingCorrupt.xml");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
        Assert.assertEquals((long)20L, (long)result.issues.size());
        Assert.assertTrue((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
        try {
            result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
            Assert.assertEquals((long)0L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            for (int i = 0; i < 20; ++i) {
                this.backdoor.issues().assignIssue("MKY-1", "admin");
                this.backdoor.issues().assignIssue("MKY-2", "admin");
                this.backdoor.issues().assignIssue("MKY-3", "admin");
                this.backdoor.issues().assignIssue("MKY-4", "admin");
                this.backdoor.issues().assignIssue("MKY-5", "admin");
            }
            result = this.backdoor.search().getSearch(new SearchRequest());
            Assert.assertEquals((long)5L, (long)result.issues.size());
            result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
            Assert.assertEquals((long)0L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
            this.backdoor.issues().commentIssue("MKY-1", "This is a comment again");
            this.backdoor.issues().commentIssue("MKY-2", "This is a comment again");
            this.backdoor.issues().commentIssue("MKY-3", "This is a comment and again");
            this.backdoor.issues().commentIssue("MKY-4", "This is a comment");
            this.backdoor.issues().commentIssue("MKY-5", "This is a comment");
            result = this.backdoor.search().getSearch(new SearchRequest().jql("comment ~ again"));
            Assert.assertEquals((long)3L, (long)result.issues.size());
            Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
        }
        finally {
            this.administration.reIndex();
        }
    }

    @Test
    public void testIfIndexConsistencyFailsIfIssueIndexDirectoryIsDeleted() {
        this.testIndexConsistencyIfIndexDirectoryIsDeleted(true, false, false, false);
    }

    @Test
    public void testIfIndexConsistencyFailsIfCommentsIndexDirectoryIsDeleted() {
        this.testIndexConsistencyIfIndexDirectoryIsDeleted(false, true, false, false);
    }

    @Test
    public void testIfIndexConsistencyFailsIfWorklogsIndexDirectoryIsDeleted() {
        this.testIndexConsistencyIfIndexDirectoryIsDeleted(false, false, true, false);
    }

    @Test
    public void testIfIndexConsistencyFailsIfChangeHistoryIndexDirectoryIsDeleted() {
        this.testIndexConsistencyIfIndexDirectoryIsDeleted(false, false, false, true);
    }

    private void testIndexConsistencyIfIndexDirectoryIsDeleted(boolean issues, boolean comments, boolean worklogs, boolean history) {
        this.setUpWithDataWithTestIndexCorrupted();
        this.backdoor.indexing().deleteIndexDirectory(issues, comments, worklogs, history);
        Assert.assertFalse((boolean)this.backdoor.indexing().isIndexConsistent());
        this.backdoor.indexing().deleteIndex();
    }

    @Test
    public void testReindexWithConcurrentIssueDeletion() {
        this.setUpWithBlankInstance();
        this.backdoor.issues().createIssue("HSP", "issue", "admin").key();
        String issueKey = this.backdoor.issues().createIssue("HSP", "issue2", "admin").key();
        BackgroundReindex reindex = new BackgroundReindex();
        reindex.runConcurrently(() -> this.backdoor.issues().deleteIssue(issueKey, false)).waitForCompletion();
        Assert.assertEquals((long)1L, (long)this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)"")).total.longValue());
        Assert.assertEquals((long)0L, (long)this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)"text ~ 'issue2'")).total.longValue());
        Assert.assertTrue((boolean)this.backdoor.indexing().isReindexTaskSuccessful(reindex.progress.getTaskId()));
    }

    @Test
    public void testReindexWithConcurrentIssueModificationAndDeletion() {
        this.setUpWithBlankInstance();
        this.backdoor.issues().createIssue("HSP", "issue", "admin").key();
        String issueKey = this.backdoor.issues().createIssue("HSP", "issue2", "admin").key();
        BackgroundReindex reindex = new BackgroundReindex();
        reindex.runConcurrently(() -> {
            this.backdoor.issues().setDescription(issueKey, "Some summary. Or another.");
            this.backdoor.issues().deleteIssue(issueKey, false);
        }).waitForCompletion();
        Assert.assertEquals((long)1L, (long)this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)"")).total.longValue());
        Assert.assertEquals((long)0L, (long)this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)"text ~ 'issue2'")).total.longValue());
        Assert.assertTrue((boolean)this.backdoor.indexing().isReindexTaskSuccessful(reindex.progress.getTaskId()));
    }

    @Test
    public void testBackgroundReindexProgressAfterArchivingProject() {
        this.setUpWithBlankInstance();
        this.backdoor.issues().createIssue("HSP", "issue", "admin");
        this.backdoor.project().addProject("ARCH", "ARCH", "admin");
        this.backdoor.issues().createIssue("ARCH", "issue2", "admin");
        this.backdoor.issues().createIssue("ARCH", "issue2", "admin");
        this.backdoor.project().archiveProject("ARCH");
        BackgroundReindex reindex = new BackgroundReindex();
        reindex.run().waitForCompletion();
        Assert.assertTrue((boolean)this.backdoor.indexing().isReindexTaskSuccessful(reindex.progress.getTaskId()));
        Assert.assertEquals((long)100L, (long)this.backdoor.indexing().getIndexingTaskProgress(reindex.progress.getTaskId()));
    }

    @Test
    public void testBackgroundReindexProgressAfterArchivingIssue() {
        this.setUpWithBlankInstance();
        this.backdoor.issues().createIssue("HSP", "issue", "admin");
        this.backdoor.project().addProject("ARCH", "ARCH", "admin");
        this.backdoor.issues().createIssue("ARCH", "issue2", "admin");
        this.backdoor.issues().createIssue("ARCH", "issue2", "admin");
        this.backdoor.issues().archiveIssue("ARCH-1");
        BackgroundReindex reindex = new BackgroundReindex();
        reindex.run().waitForCompletion();
        Assert.assertTrue((boolean)this.backdoor.indexing().isReindexTaskSuccessful(reindex.progress.getTaskId()));
        Assert.assertEquals((long)100L, (long)this.backdoor.indexing().getIndexingTaskProgress(reindex.progress.getTaskId()));
    }

    @Test
    public void testProjectReindexProgressAfterArchivingIssue() {
        this.setUpWithBlankInstance();
        this.backdoor.issues().createIssue("HSP", "issue", "admin");
        long projectId = this.backdoor.project().addProject("ARCH", "ARCH", "admin");
        this.backdoor.issues().createIssue("ARCH", "issue2", "admin");
        this.backdoor.issues().createIssue("ARCH", "issue2", "admin");
        this.backdoor.issues().archiveIssue("ARCH-1");
        this.backdoor.project().editProjectKey(projectId, "EDIT");
        Assert.assertEquals((long)100L, (long)this.backdoor.indexing().getProjectIndexingProgress(projectId).getProgress());
    }

    private void assertVotingMessage() {
        this.assertMessage("Voting");
    }

    private void assertMessage(String section) {
        this.assertions.getTextAssertions().assertTextPresent("configuration changes were made to \\'" + section + "\\' by " + "Administrator");
    }

    void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public class BackgroundReindex {
        final IssueIndexingParams issueIndexingParams;
        private IndexingControl.IndexingProgress progress;

        BackgroundReindex() {
            this.issueIndexingParams = IssueIndexingParams.INDEX_ISSUE_ONLY;
        }

        BackgroundReindex(IssueIndexingParams issueIndexingParams) {
            this.issueIndexingParams = issueIndexingParams;
        }

        public BackgroundReindex run() {
            this.progress = TestIndexingInBackground.this.backdoor.indexing().startInBackground(this.issueIndexingParams);
            return this;
        }

        public BackgroundReindex waitForCompletion() {
            this.progress.waitForCompletion();
            return this;
        }

        public BackgroundReindex runConcurrently(final Runnable testCode) {
            TestIndexingInBackground.this.backdoor.barrier().raiseBarrierAndRun("reindexing", new Runnable(){

                @Override
                public void run() {
                    BackgroundReindex.this.run();
                    TestIndexingInBackground.this.backdoor.indexing().getInBackgroundProgress().waitForIndexingStarted();
                    testCode.run();
                }
            });
            return this;
        }
    }
}

