/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.index;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.CUSTOM_FIELDS, Category.FIELDS, Category.INDEXING})
@LoginAs(user="admin")
public class TestReindexMessages
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testEditProjectFieldConfigScheme() throws Exception {
        this.administration.restoreData("TestEditProjectFieldConfigScheme.xml");
        this.changeFieldConfigSchemeAndAssertMessage(null, "System Default Field Configuration", false);
        this.changeFieldConfigSchemeAndAssertMessage(null, "Same as default scheme", false);
        this.changeFieldConfigSchemeAndAssertMessage("Same as default scheme", "Different scheme 2", true);
        this.changeFieldConfigSchemeAndAssertMessage("Different scheme 2", "Different scheme 1", true);
        this.changeFieldConfigSchemeAndAssertMessage(null, "Exhaustive 1", false);
        this.changeFieldConfigSchemeAndAssertMessage("Exhaustive 1", "Exhaustive 2 (same as default)", true);
        this.changeFieldConfigSchemeAndAssertMessage(null, "Exhaustive 2 copy with different default", false);
        this.changeFieldConfigSchemeAndAssertMessage(null, "System Default Field Configuration", false);
    }

    @Test
    public void testVoting() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().disableVoting();
        this.assertNoVotingMessage();
        this.administration.generalConfiguration().enableVoting();
        this.assertVotingMessage();
        this.administration.reIndex();
        this.administration.generalConfiguration().disableVoting();
        this.assertNoVotingMessage();
    }

    @Test
    public void testTimeTracking() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertTimeTrackingMessage();
        this.administration.reIndex();
        this.administration.timeTracking().disable();
        this.assertNoTimeTrackingMessage();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertTimeTrackingMessage();
    }

    @Test
    public void testShowHideFieldsInFieldConfiguration1() throws Exception {
        this.administration.restoreData("TestShowHideFieldsInFieldConfiguration.xml");
        this._testShowHideFieldInFieldConfigurationNoEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 2");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this._testShowHideFieldInFieldConfigurationNoEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 2");
    }

    @Test
    public void testShowHideFieldsInFieldConfiguration2() throws Exception {
        this.administration.restoreData("TestShowHideFieldsInFieldConfiguration.xml");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.project().associateFieldConfigurationScheme("homosapien", null);
        this.administration.reIndex();
        this._testShowHideFieldInFieldConfigurationHasEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 2");
    }

    @Test
    public void testShowHideFieldsInFieldConfiguration3() throws Exception {
        this.administration.restoreData("TestShowHideFieldsInFieldConfiguration.xml");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.project().associateFieldConfigurationScheme("homosapien", "Scheme X");
        this.administration.project().associateFieldConfigurationScheme("monkey", "Scheme X");
        this.administration.reIndex();
        this._testShowHideFieldInFieldConfigurationHasEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 2");
    }

    @Test
    public void testShowHideFieldsInFieldConfiguration4() throws Exception {
        this.administration.restoreData("TestShowHideFieldsInFieldConfiguration.xml");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.project().associateFieldConfigurationScheme("homosapien", "Scheme Y");
        this.administration.project().associateFieldConfigurationScheme("monkey", "Scheme Y");
        this.administration.reIndex();
        this._testShowHideFieldInFieldConfigurationHasEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 2");
    }

    @Test
    public void testAddFieldConfigurationAssociationToScheme() throws Exception {
        this.administration.restoreData("TestAddFieldConfigurationAssociationToScheme.xml");
        this.administration.project().addProject("third project", "THIRD", "admin");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 2").addAssociation("1", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 2");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("3");
        this.administration.reIndex();
        this.navigation.issue().createIssue("third project", "Bug", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Default Field Configuration");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.navigation.issue().createIssue("homosapien", "Improvement", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("4", "Field Config 2");
        this.assertFieldConfigurationMessage();
    }

    @Test
    public void testEditFieldConfigurationAssociationInScheme() throws Exception {
        this.administration.restoreData("TestEditFieldConfigurationAssociationToScheme.xml");
        this.administration.project().addProject("third project", "THIRD", "admin");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 2").editAssociation("1", "Field Config 2");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("1", "Field Config 2");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("3", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("3");
        this.administration.reIndex();
        this.navigation.issue().createIssue("third project", "Bug", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation(null, "Copy of Default Field Configuration");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 1");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("3", "Field Config 2");
        this.assertNoFieldConfigurationMessage();
        this.navigation.issue().createIssue("homosapien", "Improvement", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("4", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("4", "Default Field Configuration");
        this.assertFieldConfigurationMessage();
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("4", "Copy of Default Field Configuration");
        this.assertNoFieldConfigurationMessage();
    }

    @Test
    public void testRemoveFieldConfigurationAssociationFromScheme() throws Exception {
        this.administration.restoreData("TestEditFieldConfigurationAssociationToScheme.xml");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 2").removeAssociation("1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("3");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Copy of Default Field Configuration");
        this.administration.reIndex();
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.assertFieldConfigurationMessage();
    }

    @Test
    public void testProjectAdminCannotSee() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "fred");
        this.administration.generalConfiguration().disableVoting();
        this.assertNoVotingMessage();
        this.administration.generalConfiguration().enableVoting();
        this.assertVotingMessage();
        this.navigation.login("fred");
        this.navigation.gotoAdmin();
        this.assertNoVotingMessage();
    }

    @Test
    public void testEnableDisablePlugins() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.UPM_ADMIN_LINK);
        this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.issueoperations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.assertNoPluginsMessage();
        this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.customfieldtypes", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        this.assertNoPluginsMessage();
        this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.customfieldtypes", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        this.assertNoPluginsMessage();
        this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.issueoperations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.assertNoPluginsMessage();
        this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.customfieldtypes", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        this.assertPluginsMessage();
        this.administration.reIndex();
        this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.customfieldtypes", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        this.assertPluginsMessage();
        this.administration.reIndex();
        this.administration.plugins().disablePlugin("com.atlassian.jira.plugin.system.issueoperations");
        this.assertNoPluginsMessage();
        this.administration.plugins().disablePlugin("com.atlassian.jira.plugin.system.customfieldtypes");
        this.assertNoPluginsMessage();
        this.administration.plugins().enablePlugin("com.atlassian.jira.plugin.system.issueoperations");
        this.assertNoPluginsMessage();
        this.administration.plugins().enablePlugin("com.atlassian.jira.plugin.system.customfieldtypes");
        this.assertPluginsMessage();
    }

    private void _testShowHideFieldInFieldConfigurationNoEffect(String fieldConfigurationName) {
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).hideFields("Affects Version/s");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).showFields("Affects Version/s");
        this.assertNoFieldConfigurationMessage();
    }

    private void _testShowHideFieldInFieldConfigurationHasEffect(String fieldConfigurationName) {
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).hideFields("Affects Version/s");
        this.assertFieldConfigurationMessage();
        this.administration.reIndex();
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).showFields("Affects Version/s");
        this.assertFieldConfigurationMessage();
        this.administration.reIndex();
    }

    private void changeFieldConfigSchemeAndAssertMessage(String previousFieldConfigurationSchemeName, String newFieldConfigurationSchemeName, boolean shouldMessageBeDisplayed) {
        this.administration.project().associateFieldConfigurationScheme("monkey", newFieldConfigurationSchemeName);
        if (shouldMessageBeDisplayed) {
            this.assertNoFieldConfigurationMessage();
            this.administration.project().associateFieldConfigurationScheme("monkey", previousFieldConfigurationSchemeName);
            this.administration.reIndex();
            String issue = this.navigation.issue().createIssue("monkey", "Bug", "Test");
            this.administration.project().associateFieldConfigurationScheme("monkey", newFieldConfigurationSchemeName);
            this.assertFieldConfigurationMessage();
            this.navigation.issue().deleteIssue(issue);
            this.administration.reIndex();
        } else {
            this.assertNoFieldConfigurationMessage();
        }
    }

    private void assertVotingMessage() {
        this.assertMessage("Voting");
    }

    private void assertNoVotingMessage() {
        this.assertNoMessage("Voting");
    }

    private void assertTimeTrackingMessage() {
        this.assertMessage("Time Tracking");
    }

    private void assertNoTimeTrackingMessage() {
        this.assertNoMessage("Time Tracking");
    }

    private void assertFieldConfigurationMessage() {
        this.assertMessage("Field Configuration");
    }

    private void assertNoFieldConfigurationMessage() {
        this.assertNoMessage("Field Configuration");
    }

    private void assertCustomFieldMessage() {
        this.assertMessage("Custom Fields");
    }

    private void assertNoCustomFieldMessage() {
        this.assertNoMessage("Custom Fields");
    }

    private void assertPluginsMessage() {
        this.assertMessage("Plugins");
    }

    private void assertNoPluginsMessage() {
        this.assertNoMessage("Plugins");
    }

    private void assertMessage(String section) {
        this.assertions.getTextAssertions().assertTextPresent("configuration changes were made to \\'" + section + "\\' by " + "Administrator");
    }

    private void assertNoMessage(String section) {
        this.assertions.getTextAssertions().assertTextNotPresent("configuration changes were made to \\'" + section + "\\' by " + "Administrator");
    }
}

