/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuessecurity;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.WebLink;
import javax.inject.Inject;
import net.sourceforge.jwebunit.HttpUnitDialog;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestAddIssueSecurity
extends BaseJiraFuncTest {
    private static final String TEST_SCHEME_NAME = "test-scheme";
    private static final String TEST_SECURITY_LEVEL_NAME = "test-level";
    private static final String ADD_SECURITY_LINK_ID = "add_test-level";
    private static final String SCHEME_ID_REGEX = "schemeId=(\\d)+";
    private static final String LEVEL_ID_REGEX = "security=(\\d)+";
    private static final String ISSUE_SECURITY_PAGE_INDICATOR = "reporter_id";
    private static final String ISSUE_SECURITY_TYPE_RADIO_NAME = "type";
    private static final String ISSUE_SECURITY_TEST_GROUP = "issueSecurityGroup";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.issueSecuritySchemes().newScheme(TEST_SCHEME_NAME, "blah").newLevel(TEST_SECURITY_LEVEL_NAME, "blah");
        this.backdoor.usersAndGroups().addGroup(ISSUE_SECURITY_TEST_GROUP);
        this.backdoor.usersAndGroups().addUser("user1");
        this.backdoor.usersAndGroups().addUser("user2");
    }

    @Test
    public void testAttemptAddWithoutIssueSecurityScheme() throws Exception {
        this.goToTestScheme();
        String url = this.getLinkUrl(ADD_SECURITY_LINK_ID);
        this.logger.log((Object)("Add security link URL=" + url));
        this.navigation.gotoResource(this.removeSchemeId(url));
        this.chooseIssueSecurityType(IssueSecurityLevel.IssueSecurity.REPORTER.typeId());
        this.tester.submit();
        this.assertIsOnAddIssueSecurityPage();
        this.assertIsError("You must select a scheme to add the issue security to");
    }

    @Test
    public void testAttemptAddWithoutIssueSecurityLevel() throws Exception {
        this.goToTestScheme();
        String url = this.getLinkUrl(ADD_SECURITY_LINK_ID);
        this.logger.log((Object)("Add security link URL=" + url));
        this.navigation.gotoResource(this.removeLevelId(url));
        this.chooseIssueSecurityType(IssueSecurityLevel.IssueSecurity.REPORTER.typeId());
        this.tester.submit();
        this.assertIsOnAddIssueSecurityPage();
        this.assertIsError("You must select an issue security level for this issue security.");
    }

    @Test
    public void testAttemptAddGivenNoIssueSecurityTypeSelected() throws Exception {
        this.goToAddSecurityIssue();
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.assertIsOnAddIssueSecurityPage();
        this.assertIsError("You must select a type for this issue security.");
    }

    @Test
    public void testAddParameterlessIssueSecurity() {
        this.goToTestLevel().addIssueSecurity(IssueSecurityLevel.IssueSecurity.REPORTER).addIssueSecurity(IssueSecurityLevel.IssueSecurity.CURRENT_ASIGNEE).addIssueSecurity(IssueSecurityLevel.IssueSecurity.PROJECT_LEAD);
        this.goToAddSecurityIssue();
        this.assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity.REPORTER);
        this.assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity.CURRENT_ASIGNEE);
        this.assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity.PROJECT_LEAD);
    }

    @Test
    public void testAddParameterizedIssueSecurity() {
        this.goToTestLevel().addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, ISSUE_SECURITY_TEST_GROUP).addIssueSecurity(IssueSecurityLevel.IssueSecurity.USER, "user1").addIssueSecurity(IssueSecurityLevel.IssueSecurity.USER, "user2");
        this.goToAddSecurityIssue();
        this.assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, ISSUE_SECURITY_TEST_GROUP);
        this.assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity.USER, "user1");
        this.assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity.USER, "user2");
    }

    private IssueSecuritySchemes.IssueSecurityScheme goToTestScheme() {
        return this.administration.issueSecuritySchemes().getScheme(TEST_SCHEME_NAME);
    }

    private IssueSecurityLevel goToTestLevel() {
        return this.goToTestScheme().getLevel(TEST_SECURITY_LEVEL_NAME);
    }

    private void goToAddSecurityIssue() {
        this.goToTestScheme();
        this.tester.clickLink(ADD_SECURITY_LINK_ID);
    }

    private String getLinkUrl(String linkId) throws Exception {
        WebLink link = this.tester.getDialog().getResponse().getLinkWithID(linkId);
        Assert.assertNotNull((Object)link);
        Assert.assertNotNull((Object)link.getURLString());
        return link.getURLString();
    }

    private String removeSchemeId(String url) {
        Assert.assertTrue((boolean)url.matches(".*schemeId=(\\d)+.*"));
        return url.replaceAll(SCHEME_ID_REGEX, "");
    }

    private String removeLevelId(String url) {
        Assert.assertTrue((boolean)url.matches(".*security=(\\d)+.*"));
        return url.replaceAll(LEVEL_ID_REGEX, "");
    }

    private void chooseIssueSecurityType(String type) {
        this.assertIsOnAddIssueSecurityPage();
        this.getDialog().setFormParameter(ISSUE_SECURITY_TYPE_RADIO_NAME, type);
        this.tester.assertRadioOptionSelected(ISSUE_SECURITY_TYPE_RADIO_NAME, type);
    }

    private void assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity is) {
        this.chooseIssueSecurityType(is.typeId());
        this.tester.submit();
        this.assertIsOnAddIssueSecurityPage();
        this.assertIsError("This issue security already exists");
    }

    private void assertCannotAddIssueSecurity(IssueSecurityLevel.IssueSecurity is, String param) {
        if (is == IssueSecurityLevel.IssueSecurity.GROUP) {
            this.goToTestLevel();
            this.tester.clickLink(ADD_SECURITY_LINK_ID);
            this.tester.setFormElement(ISSUE_SECURITY_TYPE_RADIO_NAME, "group");
            FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "jiraform", " Add ");
            formParameterUtil.addOptionToHtmlSelect("group", new String[]{param});
            formParameterUtil.setFormElement("group", param);
            Node result = formParameterUtil.submitForm();
            String xpath = "//*[contains(@class, 'aui-messag') and contains(@class, 'error')]";
            XPathLocator locator = new XPathLocator(result, "//*[contains(@class, 'aui-messag') and contains(@class, 'error')]");
            this.assertions.getTextAssertions().assertTextPresent(locator, "This issue security already exists");
        } else {
            this.goToTestLevel().addIssueSecurity(is, param);
            this.assertIsOnAddIssueSecurityPage();
            this.assertIsError("This issue security already exists");
        }
    }

    private void assertIsOnAddIssueSecurityPage() {
        this.tester.assertElementPresent(ISSUE_SECURITY_PAGE_INDICATOR);
    }

    private void assertIsError(String msg) {
        this.assertions.getJiraFormAssertions().assertFormErrMsg(msg);
    }

    private HttpUnitDialog getDialog() {
        return this.tester.getDialog();
    }
}

