/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuessecurity;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.IssueSecuritySchemes;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestEditIssueSecurityLevel
extends BaseJiraFuncTest {
    private static final String TEST_SCHEME_NAME = "test-scheme";
    private static final String SECURITY_LEVEL_A = "Level A";
    private static final String SECURITY_LEVEL_B = "Level B";
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        IssueSecuritySchemes.IssueSecurityScheme scheme = this.administration.issueSecuritySchemes().newScheme(TEST_SCHEME_NAME, "blah");
        scheme.newLevel(SECURITY_LEVEL_A, "blah");
        scheme.newLevel(SECURITY_LEVEL_B, "blah");
    }

    @Test
    public void whenTryingToSaveWithEmptyNameShouldDisplayErrorMessage() {
        this.shouldDisplayErrorForName("", "Please specify a name for this security level.");
    }

    @Test
    public void whenTryingToSaveWithTooLongNameSHouldDisplayErrorMessage() {
        String newName = StringUtils.repeat((char)'a', (int)256);
        this.shouldDisplayErrorForName(newName, "Name is too long. Please enter a name shorter than 256 characters.");
    }

    @Test
    public void whenTryingToSaveWithNameThatIsAlreadyTakenShouldDisplayErrorMessage() {
        this.shouldDisplayErrorForName(SECURITY_LEVEL_B, "A Security Level with this name already exists.");
    }

    private void shouldDisplayErrorForName(String newName, String expectedMessage) {
        this.goToEditPage();
        this.tester.setFormElement("name", newName);
        this.tester.submit();
        this.assertions.getJiraFormAssertions().assertFieldErrMsg(expectedMessage);
    }

    @Test
    public void whenTryingToSaveWithDifferentDescriptionShouldSucceed() {
        this.goToEditPage();
        this.tester.setFormElement("description", "some awesome new description");
        this.tester.submit();
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
    }

    @Test
    public void whenTryingToSaveWithNoDescriptionShouldSucceed() {
        this.goToEditPage();
        this.tester.setFormElement("description", "");
        this.tester.submit();
        this.assertions.getJiraFormAssertions().assertNoErrorsPresent();
    }

    @Test
    public void whenClickingOnCancelShouldGoBackToSchemeView() {
        this.goToEditPage();
        this.tester.clickLink("cancelButton");
        this.assertions.getURLAssertions().assertCurrentURLPathEndsWith("EditIssueSecurities!default.jspa");
    }

    private void goToEditPage() {
        this.navigation.gotoPage("secure/admin/ViewIssueSecuritySchemes.jspa");
        this.navigation.clickLinkWithExactText("Security Levels");
        this.tester.clickLink(String.format("editLevel_%s", SECURITY_LEVEL_A));
    }
}

