/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING, Category.ISSUE_TYPES})
@LoginAs(user="admin")
public class TestIssueTypeDeleteFieldConfig
extends BaseJiraFuncTest {
    private static final String FIELD_NAME = "Silly Field";
    private static final String TEXT_FIELD_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:textfield";
    private static final String ISSUE_TYPE_LABEL = "Defunkt Issue Type";
    private static final Long ISSUE_TYPE_ID = 10000L;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testIssueTypeDeleteWithDanglingFieldConfigs() {
        this.administration.restoreData("TestDeleteIssueTypeWithDanglingFieldConfig.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
        this.tester.assertTextPresent("Issue Type To Delete");
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=5");
        this.tester.submit("Delete");
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Issue types");
        this.tester.assertTextNotPresent("Issue Type To Delete");
    }

    @Test
    public void testIssueTypeDeleteWithExistingFieldConfigs() {
        this.administration.restoreBlankInstance();
        IssueTypeControl.IssueType type = this.backdoor.issueType().createIssueType(ISSUE_TYPE_LABEL);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createCustomField(FIELD_NAME, TEXT_FIELD_TYPE, Collections.emptyList(), Collections.singletonList(ISSUE_TYPE_ID));
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=" + type.getId());
        this.tester.submit("Delete");
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Issue types");
        this.tester.assertTextNotPresent(ISSUE_TYPE_LABEL);
    }

    @Test
    public void testIssueTypeDeleteWithDeletedFieldConfigs() {
        this.administration.restoreBlankInstance();
        IssueTypeControl.IssueType type = this.backdoor.issueType().createIssueType(ISSUE_TYPE_LABEL);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createCustomField(FIELD_NAME, TEXT_FIELD_TYPE, Collections.emptyList(), Collections.singletonList(ISSUE_TYPE_ID));
        this.administration.customFields().removeCustomField("customfield_10000");
        this.tester.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=" + type.getId());
        this.tester.submit("Delete");
        this.textAssertions.assertTextPresent(this.locator.css("h2"), "Issue types");
        this.tester.assertTextNotPresent(ISSUE_TYPE_LABEL);
    }

    private void createCustomField(String fieldName, String fieldType, List<Long> projectIds, List<Long> issueTypeIds) {
        String cfId = this.backdoor.customFields().createCustomField(fieldName, "", fieldType, null);
        this.backdoor.customFields().createCustomFieldContext(CustomFields.numericCfId(cfId), projectIds, issueTypeIds);
    }
}

