/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestIssueTypesXSS
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    private final String xss = "\"><div id='xss-test'>XSS injected</div>";
    private final String xssEscaped = "&quot;&gt;&lt;div id=&#39;xss-test&#39;&gt;XSS injected&lt;/div&gt;";

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @After
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testIssueTypeNameDoesNotLetXSStrough() {
        IssueTypeControl.IssueType type = this.createIssueType("\"><div id='xss-test'>XSS injected</div>");
        this.tester.gotoPage("secure/CreateIssue.jspa?pid=10000&issuetype=" + type.getId());
        this.tester.assertElementNotPresent("xss-test");
        this.tester.assertTextPresent("&quot;&gt;&lt;div id=&#39;xss-test&#39;&gt;XSS injected&lt;/div&gt;");
    }

    @Test
    public void testIssueTypeDescriptionDoesNotLetXSStrough() {
        IssueTypeControl.IssueType type = this.createIssueType("XSS2", "\"><div id='xss-test'>XSS injected</div>");
        this.tester.gotoPage("secure/CreateIssue.jspa?pid=10000&issuetype=" + type.getId());
        this.tester.assertElementNotPresent("xss-test");
        this.tester.assertTextPresent("&quot;&gt;&lt;div id=&#39;xss-test&#39;&gt;XSS injected&lt;/div&gt;");
    }

    @Test
    public void testSubtaskIssueTypeNameDoesNotLetXSStrough() {
        this.administration.subtasks().enable();
        IssueTypeControl.IssueType type = this.createIssueType("\"><div id='xss-test'>XSS injected</div>", true);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue 1");
        this.tester.gotoPage("secure/CreateSubTaskIssue.jspa?pid=10000&parentIssueId=" + this.navigation.issue().getId(issueKey) + "&issuetype=" + type.getId());
        this.tester.assertElementNotPresent("xss-test");
        this.tester.assertTextPresent("&quot;&gt;&lt;div id=&#39;xss-test&#39;&gt;XSS injected&lt;/div&gt;");
    }

    @Test
    public void testSubtaskIssueTypeDescriptionDoesNotLetXSStrough() {
        this.administration.subtasks().enable();
        IssueTypeControl.IssueType type = this.createIssueType("XSS2", "\"><div id='xss-test'>XSS injected</div>", true);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue 1");
        this.tester.gotoPage("secure/CreateSubTaskIssue.jspa?pid=10000&parentIssueId=" + this.navigation.issue().getId(issueKey) + "&issuetype=" + type.getId());
        this.tester.assertElementNotPresent("xss-test");
        this.tester.assertTextPresent("&quot;&gt;&lt;div id=&#39;xss-test&#39;&gt;XSS injected&lt;/div&gt;");
    }

    private IssueTypeControl.IssueType createIssueType(String name) {
        return this.createIssueType(name, "Default Description", false);
    }

    private IssueTypeControl.IssueType createIssueType(String name, Boolean subtask) {
        return this.createIssueType(name, "Default Description", subtask);
    }

    private IssueTypeControl.IssueType createIssueType(String name, String description) {
        return this.createIssueType(name, description, false);
    }

    private IssueTypeControl.IssueType createIssueType(String name, String description, Boolean subtask) {
        IssueTypeControl.IssueType issueType = new IssueTypeControl.IssueType();
        issueType.setName(name);
        issueType.setDescription(description);
        issueType.setIconUrl("/images/icons/genericissue.gif");
        issueType.setSubtask(subtask.booleanValue());
        return this.backdoor.issueType().createIssueType(issueType);
    }
}

