/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.priorities;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.Priority;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestPriorities
extends BaseJiraFuncTest {
    @Test
    @Restore(value="TestPriorities.xml")
    public void testDefaultPriorities() {
        List priorities = this.backdoor.getTestkit().priorities().getPriorities();
        MatcherAssert.assertThat((Object)priorities, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)priorities, (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.hasPriority("1", "Highest"), this.hasPriority("2", "High"), this.hasPriority("3", "Medium"), this.hasPriority("4", "Low"), this.hasPriority("5", "Lowest")}));
    }

    @Test
    @RestoreBlankInstance
    public void testSameName() throws Exception {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PRIORITIES);
        this.addNewPriority("Blocker");
        this.assertDuplicatePriorityError();
        this.closeAddPriorityDialog();
        this.addNewPriority("BlocKER");
        this.assertDuplicatePriorityError();
        this.tester.gotoPage("secure/admin/EditPriority!default.jspa?id=2");
        this.tester.setFormElement("name", "Blocker");
        this.tester.submit();
        this.assertDuplicatePriorityError();
        this.tester.setFormElement("name", "blocker");
        this.tester.submit();
        this.assertDuplicatePriorityError();
    }

    private void addNewPriority(String name) {
        this.tester.clickLink("add-priority");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("iconurl", "/images/icons/priorities/blocker.png");
        this.tester.submit();
    }

    private void assertDuplicatePriorityError() {
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("This name is already taken.");
    }

    private void closeAddPriorityDialog() {
        this.tester.clickLink("add-edit-priority-form-cancel");
    }

    private Matcher<Priority> hasPriority(final String id, final String name) {
        return new TypeSafeMatcher<Priority>(){

            public void describeTo(Description description) {
                description.appendText(String.format("Priority(id=%s, name=%s)", id, name));
            }

            protected boolean matchesSafely(Priority priority) {
                return id.equals(priority.getId()) && name.equals(priority.getName());
            }
        };
    }
}

