/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.priorities.schemes;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Collections;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES, Category.SCHEMES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestConfigurePriorityScheme
extends BaseJiraFuncTest {
    private long schemeId;

    @Before
    public void setup() {
        this.schemeId = this.backdoor.prioritySchemes().createPriorityScheme("Test", "test", Collections.emptyList());
    }

    @Test
    public void testAddPriorityScheme() {
        this.gotoPrioritySchemes();
        this.tester.clickLink("add_priorityscheme");
        this.tester.assertFormElementEquals("name", "");
        this.tester.assertFormElementEquals("description", "");
        this.tester.assertFormElementEquals("defaultPriority", "");
        this.tester.assertSubmitButtonValue("save", "Add");
        this.assertPrioritySchemeFormValidation();
    }

    @Test
    public void testPrioritySchemeEdit() {
        this.gotoPrioritySchemes();
        this.tester.clickLink("edit_" + this.schemeId);
        this.tester.assertFormElementEquals("name", "Test");
        this.tester.assertFormElementEquals("description", "test");
        this.tester.assertSubmitButtonValue("save", "Update");
    }

    public void gotoPrioritySchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PRIORITY_SCHEMES);
    }

    private void assertPrioritySchemeFormValidation() {
        this.tester.assertTextNotPresent("You must select at least one option");
        this.tester.assertTextNotPresent("You must enter a valid name.");
        this.tester.submit("save");
        this.tester.assertTextPresent("You must select at least one option");
        this.tester.assertTextPresent("You must enter a valid name.");
        this.tester.setFormElement("name", "test name");
        this.tester.submit("save");
        this.tester.assertTextPresent("You must select at least one option");
        this.tester.assertTextNotPresent("You must enter a valid name.");
    }
}

