/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.request;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestRequestMethodCheck
extends BaseJiraFuncTest {
    private static final FeatureFlag featureFlag = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.WEBACTIONS_REQUEST_METHOD_RECOGNITION.featureKey());
    private HttpClient client;

    @Before
    public void setUp() {
        this.client = new HttpClient();
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().resetForSite(featureFlag);
    }

    @Test
    public void testThrowMethodNotAllowedForUnsupportedMethod() throws IOException {
        this.backdoor.darkFeatures().enableForSite(featureFlag);
        PutMethod putMethod = new PutMethod(this.environmentData.getBaseUrl() + "/secure/Dashboard.jspa");
        putMethod.addRequestHeader("X-Atlassian-Token", "no-check");
        this.client.executeMethod((HttpMethod)putMethod);
        Assert.assertEquals((long)405L, (long)putMethod.getStatusCode());
    }

    @Test
    public void testReturnResponseForSupportedMethod() throws IOException {
        this.backdoor.darkFeatures().enableForSite(featureFlag);
        GetMethod getMethod = new GetMethod(this.environmentData.getBaseUrl() + "/secure/Dashboard.jspa");
        this.client.executeMethod((HttpMethod)getMethod);
        Assert.assertEquals((long)200L, (long)getMethod.getStatusCode());
    }

    @Test
    public void testAllowAnyMethodWhenFeatureFlagDisabled() throws IOException {
        this.backdoor.darkFeatures().disableForSite(featureFlag);
        PutMethod putMethod = new PutMethod(this.environmentData.getBaseUrl() + "/secure/Dashboard.jspa");
        putMethod.addRequestHeader("X-Atlassian-Token", "no-check");
        this.client.executeMethod((HttpMethod)putMethod);
        Assert.assertEquals((long)200L, (long)putMethod.getStatusCode());
        GetMethod getMethod = new GetMethod(this.environmentData.getBaseUrl() + "/secure/Dashboard.jspa");
        this.client.executeMethod((HttpMethod)getMethod);
        Assert.assertEquals((long)200L, (long)getMethod.getStatusCode());
    }
}

