/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@Restore(value="TestEditCustomFieldDescription.xml")
public class TestXsrfAdminCustomFields
extends BaseJiraFuncTest {
    private static final FeatureFlag CUSTOM_FIELDS_DUAL_LIST_COMPONENT_FEATURE = FeatureFlag.featureFlag((String)"jira.customfields.dual.list.box");
    private static final FeatureFlag CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE = FeatureFlag.featureFlag((String)"jira.customfields.configure.modern.ui");
    private static final String FIELD_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect";
    private static final String FIELD_SEARCHER_KEY = "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher";
    @Inject
    private Form form;
    @Inject
    private Administration administration;

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().enableForSite(CUSTOM_FIELDS_DUAL_LIST_COMPONENT_FEATURE);
        this.backdoor.darkFeatures().enableForSite(CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE);
    }

    @Test
    public void testCustomFieldOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Custom Field", () -> {
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
            this.tester.clickLink("add_custom_fields");
            this.tester.setFormElement("fieldType", FIELD_TYPE);
        }, new XsrfCheck.FormSubmission("nextBtn")), new XsrfCheck("Edit Custom Field", () -> {
            String customFieldId = this.addCustomField();
            this.navigation.gotoPage("/secure/admin/EditCustomField!default.jspa?id=" + CustomFields.numericCfId(customFieldId));
            this.tester.setFormElement("name", "superMoreAwesomeField");
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Custom Field", () -> {
            String customFieldId = this.addCustomField();
            this.navigation.gotoPage("/secure/admin/DeleteCustomField!default.jspa?id=" + CustomFields.numericCfId(customFieldId));
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
    }

    @Test
    public void testCustomFieldConfigurationOperations() throws Exception {
        this.backdoor.darkFeatures().disableForSite(CUSTOM_FIELDS_DUAL_LIST_COMPONENT_FEATURE);
        this.backdoor.darkFeatures().disableForSite(CUSTOM_FIELDS_CONFIGURE_MODERN_UI_FEATURE);
        String customFieldId = this.addCustomField();
        String numericCustomFieldId = customFieldId.split("_")[1];
        long contextId = this.addCustomFieldContext(numericCustomFieldId);
        new XsrfTestSuite(new XsrfCheck("Configure Custom Field - Add", () -> {
            this.administration.customFields().goToCustomFieldConfiguration(numericCustomFieldId);
            this.tester.clickLink("add_new_context");
            this.tester.setFormElement("name", "my context");
            this.tester.selectOption("projects", "homosapien");
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Configure Custom Field - Edit", () -> {
            this.administration.customFields().goToCustomFieldConfiguration(numericCustomFieldId);
            this.tester.clickLink("edit_" + contextId);
        }, new XsrfCheck.FormSubmission("Modify")), new XsrfCheck("Configure Custom Field - Set Default", () -> {
            this.administration.customFields().goToCustomFieldConfiguration(numericCustomFieldId);
            this.tester.clickLink(customFieldId + "-edit-default");
        }, new XsrfCheck.FormSubmission("Set Default")), new XsrfCheck("Configure Custom Field - Delete", () -> this.navigation.gotoPage("secure/admin/ConfigureCustomField!delete.jspa?customFieldId=10000&fieldId=10111"), new XsrfCheck.FormSubmission("delete-context"))).run(this.tester, this.navigation, this.form);
    }

    private String addCustomField() {
        return this.backdoor.customFields().createCustomField("superAwesomeField", "description", FIELD_TYPE, FIELD_SEARCHER_KEY);
    }

    private long addCustomFieldContext(String numericCustomFieldId) {
        return this.backdoor.customFields().createCustomFieldContext(numericCustomFieldId, Collections.singletonList(10001L), new ArrayList());
    }
}

