/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY, Category.SCHEMES, Category.FIELDS})
@LoginAs(user="admin")
@Restore(value="TestEditCustomFieldDescription.xml")
public class TestXsrfAdminFieldConfigurationSchemes
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    private Form form;

    @Test
    public void testFieldConfigurationSchemeOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Field Configuration Schema", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("add-field-configuration-scheme");
                TestXsrfAdminFieldConfigurationSchemes.this.tester.setFormElement("fieldLayoutSchemeName", "name-add");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Copy Field Configuration Schema", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("copy_10010");
                TestXsrfAdminFieldConfigurationSchemes.this.tester.setFormElement("fieldLayoutSchemeName", "name-copied");
            }
        }, new XsrfCheck.FormSubmission("Copy")), new XsrfCheck("Edit Field Configuration Schema", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("edit_10010");
                TestXsrfAdminFieldConfigurationSchemes.this.tester.setFormElement("fieldLayoutSchemeName", "name-edited");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Field Configuration Schema", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("del_name-edited");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
    }

    @Test
    public void testFieldConfigurationConfigureOperations() throws Exception {
        this.addFieldConfigurationSchema("configure-add");
        new XsrfTestSuite(new XsrfCheck("Configure Field Configuration Edit Default", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("configure-add").goTo();
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("edit_fieldlayoutschemeentity");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Configure Field Configuration Schema Add", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("configure-add").goTo();
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("add-issue-type-field-configuration-association");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Configure Field Configuration Edit", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("configure-add").goTo();
                TestXsrfAdminFieldConfigurationSchemes.this.tester.clickLink("edit_fieldlayoutschemeentity_1");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Configure Field Configuration Delete", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurationSchemes.this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("configure-add").goTo();
            }
        }, new XsrfCheck.LinkWithIdSubmission("delete_fieldlayoutschemeentity_1"))).run(this.tester, this.navigation, this.form);
    }

    private void addFieldConfigurationSchema(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.tester.clickLink("add-field-configuration-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", name);
        this.tester.submit("Add");
    }
}

