/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@Restore(value="TestEditCustomFieldDescription.xml")
public class TestXsrfAdminFieldConfigurations
extends BaseJiraFuncTest {
    private static final String FIELD_NAME = "config-name";
    @Inject
    private Form form;

    @Test
    public void testFieldConfigurationOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Field Configuration", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
                TestXsrfAdminFieldConfigurations.this.tester.clickLink("add-field-configuration");
                TestXsrfAdminFieldConfigurations.this.tester.setFormElement("fieldLayoutName", TestXsrfAdminFieldConfigurations.FIELD_NAME);
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Copy Field Configuration", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.addFieldConfiguration();
                TestXsrfAdminFieldConfigurations.this.tester.clickLink("copy-config-name");
            }
        }, new XsrfCheck.FormSubmission("Copy")), new XsrfCheck("Edit Custom Field", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.addFieldConfiguration();
                TestXsrfAdminFieldConfigurations.this.tester.clickLink("edit-config-name");
                TestXsrfAdminFieldConfigurations.this.tester.setFormElement("fieldLayoutName", "config-name-i-edit-you");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Custom Field", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.addFieldConfiguration();
                TestXsrfAdminFieldConfigurations.this.tester.clickLink("delete-config-name");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.tester, this.navigation, this.form);
    }

    @Test
    public void testFieldConfigurationConfigureOperations() throws Exception {
        this.addFieldConfiguration();
        new XsrfTestSuite(new XsrfCheck("Configure Field Configuration Edit", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.viewConfiguration();
                TestXsrfAdminFieldConfigurations.this.tester.clickLink("edit_0");
                TestXsrfAdminFieldConfigurations.this.tester.setFormElement("description", "OMG description ^_^");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Configure Field Configuration Hide", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.viewConfiguration();
            }
        }, new XsrfCheck.LinkWithIdSubmission("hide_0")), new XsrfCheck("Configure Field Configuration Show", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.viewConfiguration();
            }
        }, new XsrfCheck.LinkWithIdSubmission("show_0")), new XsrfCheck("Configure Field Configuration Required", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.viewConfiguration();
            }
        }, new XsrfCheck.LinkWithIdSubmission("require_0")), new XsrfCheck("Configure Field Configuration Optional", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.viewConfiguration();
            }
        }, new XsrfCheck.LinkWithIdSubmission("require_0")), new XsrfCheck("Configure Field Configuration Renderers", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminFieldConfigurations.this.viewConfiguration();
                TestXsrfAdminFieldConfigurations.this.tester.clickLink("renderer_versions");
                TestXsrfAdminFieldConfigurations.this.tester.setWorkingForm("jiraform");
                TestXsrfAdminFieldConfigurations.this.tester.clickButton("update_submit");
            }
        }, new XsrfCheck.FormSubmission("Update"))).run(this.tester, this.navigation, this.form);
    }

    private void addFieldConfiguration() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("add-field-configuration");
        this.tester.setFormElement("fieldLayoutName", FIELD_NAME);
        this.tester.clickButton("add-field-configuration-submit");
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
    }

    private void viewConfiguration() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-config-name");
    }
}

